REM $INCLUDE: 'fastgraf.bi'

DEFINT A-Z

REM Ask for the video mode number

INPUT "Which video mode"; Mode

REM Make sure the entered value is valid

IF Mode < 0 OR Mode > 29 THEN
   PRINT Mode; "is not a valid video mode number."
   STOP
END IF

REM Make sure the requested video mode is available

IF FGtestmode(mode,1) = 0 THEN
   PRINT "Mode"; Mode; "is not available on this system."
   STOP
END IF

REM Establish the video mode

OldMode = FGgetmode
FGsetmode Mode

REM Perform mode-specific initializations

IF Mode <= 3 OR Mode = 7  THEN    ' text modes
   FGcursor 0

ELSEIF Mode = 4 OR Mode = 5 THEN ' CGA color modes
   FGpalette 0, 0
   FGdefcolor 14, 3

ELSEIF Mode = 6 THEN             ' CGA two-color mode
   FGpalette 0, 14
   FGdefcolor 14, 1

ELSEIF Mode = 11 THEN            ' Hercules mode
   FGdefcolor 14, 1

ELSEIF Mode = 12 THEN            ' Hercules low-res mode
   FGdefcolor 14, 3

ELSEIF Mode = 17 THEN            ' VGA two-color mode
   FGpalette 1, 14
   FGsetrgb 14, 63, 63, 21
   FGdefcolor 14, 1
END IF

REM Display a message that includes the video mode number

FGsetcolor 14
FGtext "I'm running in mode", 19
FGtext STR$(Mode), LEN(STR$(Mode))
FGtext ".", 1

REM Wait for a keystroke

FGwaitkey

REM Restore the original video mode and screen attributes

FGsetmode OldMode
FGreset

END
