/*
 *  STARTD:  A simple program to start a DOS session under OS/2 2.0.  
 *           This program can be run from an OS/2 command prompt
 *
 *  Last Modfied: 07/07/92
 *
 *  Author: Norm Ross
 *  
 *  Using the example code for BOOTA.C found in IBM DOCUMENT GBOF-2254
 *
 *  This was written mainly to provide access to DOS SETTINGS for
 *  VDM sessions. Since I have disabled the WPS to free up the space,
 *  I can't specify DOS settings for my favorite DOS apps.
 *  STARTD is not meant to replace START but it does many of
 *  the same things...
 *
 *  If you change this program and re-distribute it please leave this
 *  header intact and send the readme file with it.
 * 
 *  MODIFICATION HISTORY
 *   
 *  07-Jul-1992  Norm Ross, npross@undergrad.uwaterloo.ca
 *     1.00 : Initial version
 *
 */
/*  April 16, 1993 John Morris
 *     Fixes to /WAIT command
 *     Added /NODEx command to allow for unique queue names (used when
 *     waiting for a child session to end)
 *     Converted to use by Watcom C9.01
 */

#define INCL_DOSSESMGR
#define INCL_DOSMISC
#define INCL_DOSPROCESS
#define INCL_DOSQUEUES
#define INCL_DOSERRORS
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <io.h>

// My own idiosyncracies..
#define NOT   !
#define AND   &&

PBYTE ReadDOSSettings(PSZ pFileName);

CHAR szPgmInputs[256];
CHAR szDosPgmInputs[256];

// Additions
CHAR QueueName[32];

STARTDATA startd;                  /* Session start information */
ULONG SessionID;                   /* Session and Process ID for new session*/
PID ProcessID;

int main(int argc, char *argv[])
{
    APIRET  ReturnCode;
    BOOL    flagWin   = FALSE,
            flagFs    = FALSE,
            flagKeep  = FALSE,
            flagNoCmd = FALSE;

    BOOL    GotENV    = FALSE;
    PSZ     ENVSwitches = NULL;
    PSZ     PgmTitle  = NULL;
    HQUEUE  QueueHandle;
    LONG    Node      = 1;
    PSZ     INIFileName = NULL;
    PSZ    *ArgVars;
    int     ArgCount;
    int     Index;
    PSZ     TmpPtrs[22];


    ArgCount = argc;

    ArgVars = argv;

    printf("StartD 2.0 - Session Launcher\n");

    /* ---- init startd struct defaults */
    startd.Length                   = sizeof(STARTDATA);
    startd.Related                  = SSF_RELATED_INDEPENDENT;
    startd.FgBg                     = SSF_FGBG_FORE;
    startd.TraceOpt                 = SSF_TRACEOPT_NONE;
    startd.PgmTitle                 = NULL;
    startd.PgmName                  = NULL;
    startd.PgmInputs                = NULL;
    startd.TermQ                    = NULL;
    startd.Environment              = NULL;
    startd.InheritOpt               = SSF_INHERTOPT_PARENT;
    startd.SessionType              = SSF_TYPE_DEFAULT;
    startd.PgmControl               = SSF_CONTROL_VISIBLE;
    startd.FgBg                     = SSF_FGBG_FORE;

    // Get program title from environment
    // Command line "Title" will override
    PgmTitle = getenv("STARTD_TITLE");

    if (PgmTitle)
        startd.PgmTitle = strdup(PgmTitle);

ProcessArgs:
  /* ------ Process args */
    while (--ArgCount > 0)
    {
        char *arg;

        switch (**++ArgVars)
        {
            case '\"':
                startd.PgmTitle = strtok(*ArgVars, "\"");
                break;
            case '-':
            case '/':
                arg = (*ArgVars) + 1;
                if (strlen(arg) == 1) 
                {
                    switch(*arg) 
                    {
                        case 'n':
                        case 'N':
                            flagNoCmd = TRUE;
                            break;
                        case 'k':
                        case 'K':
                            flagKeep = TRUE;
                            break;
                        case 'c':
                        case 'C':
                            break;
                        case 'd':
                        case 'D':
                            startd.SessionType = SSF_TYPE_VDM;
                            break;
                        case 'f':
                        case 'F':
                            startd.FgBg = SSF_FGBG_FORE;
                            break;
                        case 'b':
                        case 'B':
                            startd.FgBg = SSF_FGBG_BACK;
                            break;
                        case 'i':
                        case 'I':
                            startd.InheritOpt = SSF_INHERTOPT_SHELL;
                            break;
                        case '?':
                            usage();
                            break;
                        default:
                            fprintf(stderr, "Unrecognized option: %s\n", arg);
                            usage();
                            break;
                    }
                }
                else if (strnicmp(arg, "DO", 2) == 0)
                {
                    startd.SessionType = SSF_TYPE_VDM;
                }
                else if (strnicmp(arg, "WI", 2) == 0)
                {
                    flagWin = TRUE;
                }
                else if (strnicmp(arg, "WA", 2) == 0)
                {
                    startd.Related = SSF_RELATED_CHILD;
                }
                else if (stricmp(arg, "FS") == 0)
                {
                    flagFs = TRUE;
                }
                else if (stricmp(arg, "FG") == 0)
                {
                    startd.FgBg = SSF_FGBG_FORE;
                }
                else if (stricmp(arg, "BG") == 0)
                {
                    startd.FgBg = SSF_FGBG_BACK;
                } 
                else if (strnicmp(arg, "MA", 2) == 0)
                {
                    startd.PgmControl |= SSF_CONTROL_MAXIMIZE;
                } 
                else if (strnicmp(arg, "MI", 2) == 0)
                {
                    startd.PgmControl |= SSF_CONTROL_MINIMIZE;
                } 
                else if (strnicmp(arg, "IN", 2) == 0)
                {
                    startd.PgmControl |= SSF_CONTROL_INVISIBLE;
                } 
                else if (stricmp(arg, "PM") == 0)
                {
                    startd.SessionType = SSF_TYPE_PM;
                } 
                else if (strnicmp(arg, "pos", 3) == 0)
                {
                    PSZ s;
        
                    s = strtok(arg, "=");

                    /* ---- I really should check strtok's return... */
                    startd.PgmControl |= SSF_CONTROL_SETPOS;
                    startd.InitXPos = atoi(strtok(NULL, ","));
                    startd.InitYPos = atoi(strtok(NULL, ","));
                    startd.InitXSize = atoi(strtok(NULL, ","));
                    startd.InitYSize = atoi(strtok(NULL, ""));
                } 
                else if (stricmp(arg, "PGM") == 0)
                {
                    PSZ p = szPgmInputs;

                    /* ---- strip quotes from name if there are any */
                    startd.PgmName = strtok(*ArgVars, "\"");
 
                    /* ---- cat the rest of the args together to pass to pgm */
                    while (ArgCount > 1)
                    {
                        ArgCount--;
                        ArgVars++;
                        strcpy(p, *ArgVars);
                        p += strlen(*ArgVars);
                        *p++ = ' '; /* put spaces between the args */
                    }
                    *p = '\0';

                    startd.PgmInputs = szPgmInputs;
                    break;
                } 
                else if (strnicmp(arg, "IC", 2) == 0)
                {
                    startd.IconFile = *++ArgVars;
                    ArgCount--;
                } 
                else if (stricmp(arg, "SF") == 0)
                {
                    INIFileName = *++ArgVars;

                    ArgCount--;

                    if (access(INIFileName, 0)) 
                    {
                        fprintf(stderr, "Session File '%s' not found\n", INIFileName);
                    }

                    startd.Environment = ReadDOSSettings(INIFileName);
                }
                else if (strnicmp(arg, "nd", 2) == 0)
                {
                    Node = atoi(arg + 2);
                }
                else
                {
                    printf("Unrecognized option: %s\n", arg);
                    usage();
                }
                break;

            default:
            {
                PSZ p = szPgmInputs;

                startd.PgmName = *ArgVars;
          
                /* ---- cat the rest of the args together to pass to pgm */
                while (ArgCount > 1)
                {
                    ArgCount--;
                    ArgVars++;
                    strcpy(p, *ArgVars);
                    p += strlen(*ArgVars);
                    *p++ = ' '; /* put spaces between the args */
                }
                *p = '\0';

                startd.PgmInputs = szPgmInputs;
                break;
            }

        } 
    } 

    // See if we have switches in the OS/2 environment
    // if so, load 'em in.. tokenize 'em and use 'em
    if (NOT GotENV)
    {
        ENVSwitches = getenv("STARTD_SWITCHES");

        if (ENVSwitches)
        {
            GotENV = TRUE;

            // zero out pointers
            for (Index = 0; Index < 22; Index++)
            {
                TmpPtrs[Index] = NULL;
            } 

            // make a copy that we can modify
            ENVSwitches = strdup(ENVSwitches);

            ArgCount = 1;

            // TmpPtrs[0] is work pointer
            // TmpPtrs[1..20] contain switches
            // TmpPtrs[21] is always NULL
            // this conforms with normal cmd line parms
            TmpPtrs[0]  = strtok(ENVSwitches, " ");

            while (TmpPtrs[0] AND ArgCount < 21)
            {
                TmpPtrs[ArgCount++] = TmpPtrs[0];

                TmpPtrs[0] = strtok(NULL, " ");
            }

            ArgVars = TmpPtrs;

            goto ProcessArgs;
        }
    }

    /* ------ Start thru Command processor */
    if ((startd.PgmName != NULL) AND
        (startd.SessionType != SSF_TYPE_PM) AND
        (NOT flagNoCmd))
    {
        if (flagKeep)
            strcpy(szDosPgmInputs, "/k ");
        else
            strcpy(szDosPgmInputs, "/c ");

        strcat(szDosPgmInputs, startd.PgmName);
        strcat(szDosPgmInputs, " ");
        strcat(szDosPgmInputs, startd.PgmInputs);
        startd.PgmInputs = szDosPgmInputs;
        startd.PgmName = NULL;
    }

    /* ------ Set the correct session type */
    if (flagWin)
    {
        switch (startd.SessionType)
        {
            case SSF_TYPE_DEFAULT:
                startd.SessionType = SSF_TYPE_WINDOWABLEVIO;
                break;
            case SSF_TYPE_VDM: 
                startd.SessionType = SSF_TYPE_WINDOWEDVDM; 
                break;
            case SSF_TYPE_PM:
                break;
        }
    } 
    else if (flagFs)
    {
        switch (startd.SessionType)
        {
            case SSF_TYPE_DEFAULT:
                startd.SessionType = SSF_TYPE_FULLSCREEN;
                break;
            case SSF_TYPE_VDM: 
            case SSF_TYPE_PM:
                break;
        }
    }

    // Open queue to get term code...  used to wait for process to end!
    if (startd.Related == SSF_RELATED_CHILD)
    {
        do
        {
            sprintf(QueueName, "\\QUEUES\\STRTD%ld.QUE", Node);

            ReturnCode = DosCreateQueue(&QueueHandle, QUE_FIFO | QUE_NOCONVERT_ADDRESS, QueueName);

            if (ReturnCode == ERROR_QUE_DUPLICATE)
                Node++;                     // try for a unique node # if one not
            else if (ReturnCode)            // specified
            {
                fprintf(stderr, "Error %ld opening queue!\n", ReturnCode);
                return (-1);
            }

        } while (ReturnCode);

        startd.TermQ = QueueName;
    }

    if (NOT (startd.PgmControl & SSF_CONTROL_SETPOS))
    {
        startd.PgmControl |= SSF_CONTROL_SETPOS;
        startd.InitXPos    = 50;
        startd.InitYPos    = 50 * Node;
        startd.InitXSize   = 350;
        startd.InitYSize   = 225;
    }

    printf("Program    : \"%s\"\n", startd.PgmName ? startd.PgmName : "Command Processor");
    printf("Options    : \"%s\"\n", startd.PgmInputs ? startd.PgmInputs : "");
    printf("INI File   : \"%s\"\n", INIFileName ? INIFileName : "");

    /* ------ Start the Session */
    ReturnCode = DosStartSession(&startd, &SessionID, &ProcessID);

    if (ReturnCode == ERROR_SMG_START_IN_BACKGROUND)
    {
        //  /FG (foreground) selected, but since parent session is in background
        //  child application will also be started in the background. So the docs say.

        printf("* Child Session Started in Background *\n");
    }
    else if (ReturnCode)
    {

        /* ------ Print out failure message */
        printf("StartD Error Code (%ld) ", ReturnCode);

        switch (ReturnCode)
        {
            case ERROR_FILE_NOT_FOUND:
                printf("* File Not Found *\n");
                break;
            case ERROR_BAD_EXE_FORMAT:
                printf("* Tried Starting DOS program without /D ?? *\n");
                break;
            case ERROR_BAD_ARGUMENTS:
                printf("* Command Line Too Long? * \n");
                break;
        }

        return (ReturnCode);
    }

    printf("Session ID : %ld\n", SessionID);

    if (startd.Related == SSF_RELATED_CHILD)
    {
        /* ------ Wait for child to finish */
        REQUESTDATA Request;
        ULONG   DataLength;
        PUSHORT DataAddress;
        ULONG   ElementCode;
        BOOL    NoWait;
        BYTE    ElementPriority;

        ElementCode = 0;
        NoWait      = FALSE;

        printf("Waiting...\n");
        while (DosReadQueue(QueueHandle, &Request, &DataLength,
                            &DataAddress, ElementCode, NoWait,
                            &ElementPriority, 0))
            DosSleep(100);

        ReturnCode = (int) DataAddress[1];

        printf("Return Code: %ld\n", ReturnCode);

        DosFreeMem(DataAddress);    // nuke data..as per d'docs
    }

    return (ReturnCode);
}

#define MAXENV 4096
PBYTE ReadDOSSettings(PSZ FileName) 
{
    FILE *fptr;
    PBYTE env = (PBYTE) malloc(MAXENV);
    PBYTE p = env;

    fptr = fopen(FileName, "r");
    if (NOT fptr)
    {
        fprintf(stderr, "\nFile '%s' cannot be found\n");
        exit(-1);
    }

    while (fgets(p, 80, fptr))
    {
        p += strlen(p);
        *(p - 1) = '\0';
        if (p > (env + 4096))
        {
            fprintf(stderr, "ERROR: too many settings\n");
            fflush(stderr);
            exit(-1);
        }
    }

    realloc(env, p-env);

    return(env);
}

VOID usage(VOID)
{
    fprintf(stderr, "STARTD VERSION 2.0 by Norm Ross Copyright (c) 1992\n                   Mods by John Morris 1993\n\n");
    fprintf(stderr, "startd [\"program title\"] [/BG /C /DOS /F /FS /I /ICON iconfile /INV /K /MAX\n\t /MIN /PGM /POS=x,y,x1,y1 /SF settingsfile /WIN] [command ...]\n\n");
    fprintf(stderr, "\t/B\t start session in background\n");
    fprintf(stderr, "\t/C\t close session upon completion\n");
    fprintf(stderr, "\t/DOS\t start a dos session\n");
    fprintf(stderr, "\t/F\t start session in foreground\n");
    fprintf(stderr, "\t/FS\t start a full screen session\n");
    fprintf(stderr, "\t/I\t sets SSF_INHERTOPT_SHELL\n");
    fprintf(stderr, "\t/ICON\t uses the specified icon file\n");
    fprintf(stderr, "\t/INV\t start the application invisibly\n");
    fprintf(stderr, "\t/K\t keep the session around after it is finished\n");
    fprintf(stderr, "\t/MAX\t start maximized\n");
    fprintf(stderr, "\t/MIN\t start minimized\n");
    fprintf(stderr, "\t/N\t don't start indirectly through command processor\n");
    fprintf(stderr, "\t/NODEx\t set unique node number (identity)\n");
    fprintf(stderr, "\t/PGM\t the next argument is the program name\n");
    fprintf(stderr, "\t/PM\t start a PM program\n");
    fprintf(stderr, "\t/POS=x,y,x1,y1\t specify window position and size\n");
    fprintf(stderr, "\t/SF\t read the specified dos settings file\n");
    fprintf(stderr, "\t/WIN\t start a windowed session\n");
    fprintf(stderr, "\t/WAIT\t wait for child process to end\n");
    exit(1);
}
