//----------------------- StackKey.prg -----------------------------------
/***
*
*  PushKeys(), PopKeys(), ResetAllKeys()
*
*  SET KEY stack system
*
*  By Patrick Oonk
*
*  PushKeys()                       // save SET KEY settings
*  set key K_F2 to SomeLookup()
*  // do something
*  PopKeys()                        // restore SET KEY settings
*/

STATIC aKeyStack := {}

// save all SET KEY settings on stack
FUNCTION PushKeys()
   LOCAL n
   aadd(aKeyStack, {})
   for n := -39 to 306
      aadd(aKeyStack[len(aKeyStack)], setkey(n))
   next
RETURN( NIL )


// pop SET KEY stack
FUNCTION PopKeys()
   LOCAL n, n2 := 0
   for n := -39 to 306
      setkey(n, aKeyStack[len(aKeyStack),++n2])
   next
   asize(aKeystack, len(aKeyStack)-1)
RETURN( NIL )


// reset all SET KEYS
FUNCTION ResetAllKeys()
   LOCAL n
   for n := -39 to 306
      setkey(n, NIL)
   next
RETURN( NIL )

--------------------------------- StackSets.prg ---------------------------

/***
*
*  PushSets(), PopSets()
*
*  SET KEY stack system
*
*  By Patrick Oonk, R.W. Vergeer
*
*  Example:
*
*  PushSets()        // save current sets
*  set deleted off
*  // do something
*  PopSets()         // restore sets
*
*/

#include "Set.ch"

STATIC aSets := {}

FUNCTION PushSets()
   LOCAL n
   aadd(aSets, {})
   for n := 1 TO _SET_COUNT
      aadd(aSets[len(aSets)],  SET(n))
   next
RETURN ( NIL )

FUNCTION PopSets()
   LOCAL n
   for n := 1 TO _SET_COUNT
      set(n, aSets[len(aSets), n])
   next
   asize(aSets, len(aSets)-1)
RETURN ( NIL )
