When processing multiple gets with a single read, it is possible (and likely)
that the user might terminate the read before entering a get whose data is
required.  I've often wished, if the user terminated the read for any other
reason than aborting it, that the gets could be re-validated in a painless
manner to ensure that all *required* fields were entered.  Not wanting to resort
to a separate validation routine to be called after the read terminates, I poked
around 5.01's GETSYS.prg and came up with the following solution.

I use the "cargo" instance variable to hold a logical value indicating whether
the get is required, as follows:

  #define REQUIRED  .t.

  @ 5, 10 get cTest1 pict 'XXXXX' valid { |oGet| GottaHavIt( oGet ) }
  atail( GetList ):cargo := REQUIRED

  @ 6, 10 get cTest2 pict 'XXXXX' valid CheckTest2( cTest2 )
  atail( GetList ):cargo := REQUIRED

That's all the programming necessary in your day to day coding.  The rest is a
one-time modification to GETSYS.prg as shown below.  You could redefine the
@..GET command with a "REQUIRED" clause to make it even simpler.  If you're
already using cargo for some other purpose, you can make it a nested array and
stick the REQUIRED flag in the array wherever it suits your fancy (and modify
the code below accordingly):

Insert these two lines immediately after the line
"local savedGetSysVars" in the ReadModal() function:

  local nGets := len( GetList )
  local n

Insert this code fragment immediately after the line
"pos := Settle( GetList, pos )" and before the line "end" in the ReadModal()
function:

  // validate gets whose cargo value is .t. (required)
  if pos = 0 .and. LastExit != GE_ESCAPE
    for n := 1 to nGets
      get := GetList[ n ]
      if get:cargo != nil .and. get:cargo   // Is the get required?
        if get:postBlock != nil             // Is there a valid?
          if ( GetPreValidate( get ) )      // If when satisfied...
            get:setFocus()                  // Give the get focus
            if ( !GetPostValidate( get ) )  //  and validate it.
              pos := n
              exit
            endif
            get:KillFocus()
          endif
        endif
      endif
    next
  endif

Insert this line immediately after the line
"if ( exitState == GE_ESCAPE .or.  exitState == GE_WRITE )" and
before the line "return ( 0 )" in the Settle() function:

  LastExit := exitState

That should be all there is to it.  I've made other mods to GetSys,
but I think I pulled out the ones pertinent to the topic.  Please
give me some feedback if you try this.
