 FUNCTION getcmdln()
 /*
 * Returns a string containing the "tail" of the command line
 * used to start the program.  Requires the Nanforum library.
 *
 * Written by Ronald Bass.  Dedicated to the Public Domain.
 */
 # include "ftint86.ch"
 // Make sure you use the pre-NFPAT5 version of the header file or edit
 // to insert the omitted escape "\"s in the highbyte() and lowbyte()
 // pseudo-functions.  We don't use those functions here, but the bug
 // intoduced in NFPAT5 will still cause the compile to fail.

 LOCAL CMDLN, OFFSET, aREGS[10], nchar, i

 aREGS[AX] = makehi(98)   // Setting up Int 21h, Function 62h
 FT_INT86(33,aREGS)       // Returns the segment of the PSP in aREGS[BX]

 CMDLN :=""
 OFFSET := 128      // Byte at offset 80h contains # of characters in
                    // command tail.  Command tail starts at offset 81h.
                    // Command tail is *not* null terminated.

 nchar := FT_PEEK( aREGS[BX], offset++) // number of characters in
                                        // command tail string
 for i = 1 to nchar
   CMDLN += CHR( FT_PEEK( aREGS[BX], offset++) )  // gets the characters
                                                  // one by one
 next
 RETURN ( CMDLN )

 CUT HERE> --------------------------------------------
