
 Area:    CLIPPER
 Date:    13 Aug 92  23:04:00  Public           
 From:    Terry Carmen             
 To:      All                      
 Subject: 132 columns                                                 

I've been persuing the quest for a 132 column display in Clipper on and off for
the past few weeks.

With the help of codeview, turbo debugger, some helpful folks on the Compu$erve
Clipper forum, and a few miscellaineous tools, and some sneaky debugging, I've
finally got it working!

Since there may be others here who would like to do neat things like view a 132
column report on the screen, in one piece, I'm posting all the sordid details
here 8-)

I was originally going to post it on the C$ Clipper forum also, but there is
apparently a problem there. My original thread discussed how I identified and
accessed some Clipper internals, and the thread mysterously disappeared the day
after I started it. Go figure. It must be those bugs again 8-)

The messages are still on C$erve, but there doesn't seem to be any way to access
the thread. If anybody wants to poke around, the starting message number was
245941

In any event, here's the code:

Note that mode 85 only works on VGAs. If you want to see what modes your
particular adapter supports, check it's documentation, or Ralf Brown's interrupt
list, under int 10h, ah=0.

Also note that selecting a mode that isn't supported by your adapter / display
may cause damage to either or both, sunspots, bad karma, your girlfriend
leaving, bad breath, or any other awful things. This works great for me, but all
I guarantee is that if you use it, and it breaks in two, you can keep both
halves.

Let me know how it works out for you!

If you don't see "*********************end of code**************" at
the bottom of the message, something truncated it.


********************Clipper Code**********************
procedure tiny             // sets up 25x132 columns on my VGA card

    videomode(85)
    setmode()              // this apparently causes Clipper to
                           // re-sync it's internal settings with reality
return

procedure normal


    videomode(3)              // 25x80
    setmode(25,80)            // for some reason we have to
    setmode(25,80)            // reinit Clipper twice to reset properly
                              // setmode() just locks up the computer,
                              // and a single setmode(25,80) get us
                              // a 40 column display for some reason
return

**************************************************
************ASM Code (TASM or MASM)***************

public  videomode

extrn   __retl:far
extrn   __parni:far
extrn   __parinfo:far

             CL_NUMERIC    equ 2

_prog   segment 'CODE'
             assume  cs:_prog

videomode    proc    far
             push bp
             mov bp, sp

             ; save the regs, because the video BIOS changes
             ; some of them and I'm paranoid about returning
             ; changed registgers to Clipper

             push ds
             push es
             push si
             push di
             push dx
             push cx
             push bx
             push ax

            mov ax, 0
            push ax
            call __parinfo
            add sp, 2
            cmp al, 1                 ; 1 param?
            jne @@badexit

            mov ax, 1
            push ax
            call __parinfo
            add sp, 2
            cmp al, CL_NUMERIC         ; is it numeric?
            jne @@badexit

            mov ax, 1
            push ax
            call __parni                ; get the first paramater
            add sp, 2                   ; leaves video mode in ax
            int 10h                     ; call the video BIOS

            ; we assume the mode change worked, since the return
            ; value is adapter dependant

             mov ax, 1                  ; return .T.
             jmp short @@bye

@@badexit:   mov ax, 0

@@bye:       push ax
             call __retl
             add sp, 2

             pop ax
             pop bx
             pop cx
             pop dx
             pop di
             pop si
             pop es
             pop ds
             pop bp
             ret

videomode    endp
_prog        ends
             end

********************end of code************************
