/(*
Syntax 
 
    SHAlert(<aMessage>,[<aOptions>],[<cBoxColor>],[<cOptColor>]) -> nChoice 
 
Arguments 
 
    <aMessage> is an array of character strings less to display in a pop-up 
    box on the screen one above the other and centred both vertically and  
    Horizontally.  
 
    <aOptions> is an array of character strings to be used as prompts.  The 
    elements will be displayed across the screen with two spaces between them. 
    If this parameter is not included, the only option will be "Continue". 
     
    <cBoxColor> is a color string to use for the pop-up box. 
     
    <cOptColor> is the color string to use for the options on the bottom line. 
 
Returns 
 
    SHAlert() returns the number of the option the user selected. 
 
     
Description 
 
    Use to pop up a message to the user and allow them to select from an 
    array of choices, or simply select continue.  Good for error messages. 
 
    Use instead of clipper's Alert() function which has defficiencies and 
    some parameters are undocumented so may not exist in future releases. 
    Also improves color handling. 
     
Example 
     
    This example is for a user who has requested access to a file which does 
    not exist. 
     
    Do While .T. 
      If .not. File(cFileName := GetFileNam()) 
        If SHAlert({"The file you selected does not exist." ,; 
                     "Would you like to look for it again?"} ,; 
                     {"Look Again","Quit"}) == 2 
          Exit 
        EndIf 
      Else 
        Exit 
      EndIf 
    EndDo 
    : 
    Return 
*/
 
/* 
+-----------------------------------------------------------------------------+ 
|   Function to replace Alert.                                                | 
+-----------------------------------------------------------------------------+ 
*/ 
Function SHAlert(aMessage,aOptions,cBoxColor,cOptColor) 
Local nBoxHeight          ,; 
      nBoxTop             ,; 
      nBoxWidth           ,; 
      nBoxLeft            ,; 
      cScreen             ,; 
      cColor := SetColor(),; 
      nChoice             ,; 
      aPosition := {}     ,; 
      nWidth              ,; 
      I                   ,; 
      nLineWidth          ,; 
      lEscape := Set(_SET_ESCAPE),; 
      cPrinterTo := Set(_SET_PRINTFILE),; 
      lPrinterOn := Set(_SET_PRINTER)  ,; 
      lConsole   := Set(_SET_CONSOLE)  ,; 
      cDevice    := Set(_SET_DEVICE) 
If aMessage == Nil .or. ValType(aMessage) <> "A" 
  Return 0 
EndIf 
If aOptions == Nil .or. ValType(aOptions) <> "A" 
  aOptions := {"Continue"} 
EndIf 
If cBoxColor == Nil .or. ValType(cBoxColor) <> "C" 
  cBoxColor := SetColor() 
EndIf 
If cOptColor == Nil .or. ValType(cBoxColor) <> "C" 
  cOptColor := cBoxColor 
EndIf 
SetColor(cBoxColor) 
Set Escape Off 
Set Device to Screen 
Set Console On 
Set Print Off 
nBoxHeight := Len(aMessage) + 3 
nBoxTop    := Int((MaxRow() - nBoxHeight)/2) 
nWidth := 0 
AEVal(aOptions,{| nCurrWidth | nWidth += Len(nCurrWidth) + 4}) 
nBoxWidth  := AMaxStrLen(aMessage) + 4 
If nBoxWidth < nWidth + 4 
  nBoxWidth := nWidth + 4 
EndIf 
nBoxLeft   := Int((MaxCol() - nBoxWidth)/2) 
cScreen    := SaveScreen(nBoxTop,nBoxLeft,nBoxTop + nBoxHeight + 1,; 
                         nBoxLeft + nBoxWidth + 2) 
@ nBoxTop,nBoxLeft to nBoxTop + nBoxHeight,nBoxLeft + nBoxWidth 
@ nBoxTop + 1,nBoxLeft + 1 clear to nBoxTop + nBoxHeight - 1,; 
  nBoxLeft + nBoxWidth - 1 
// comment the following lines out if you do not have FUNCKY 
SetAttr(nBoxTop+1,nBoxLeft+nBoxWidth+1,nBoxTop+nBoxHeight,nBoxLeft+nBoxWidth+2,;

        7) 
SetAttr(nBoxTop+nBoxHeight+1,nBoxLeft+2,nBoxTop+nBoxHeight+1,nBoxLeft+; 
        nBoxWidth+2,7) 
For I := 1 to Len(aMessage) 
  nLineWidth := Len(aMessage[i]) 
  @ nBoxTop + I,Int((MaxCol() - nLineWidth)/2) Say aMessage[i] 
Next 
SetColor(cOptColor) 
ASize(aPosition,Len(aOptions)) 
aPosition[1] := Int((MaxCol() - nWidth)/2) + 2 
@ nBoxTop + nBoxHeight - 1,aPosition[1] Prompt " " + aOptions[1] + " " 
For I := 2 to Len(aOptions) 
  aPosition[i] := aPosition[i - 1] + Len(aOptions[i - 1]) + 4 
  @ nBoxTop + nBoxHeight - 1,aPosition[i] Prompt " " + aOptions[i] + " " 
Next 
Menu to nChoice 
RestScreen(nBoxTop,nBoxLeft,nBoxTop+nBoxHeight+1,nBoxLeft+nBoxWidth+2,cScreen) 
SetColor(cColor) 
Set(_SET_ESCAPE,lEscape) 
Set(_SET_PRINTFILE,cPrinterTo,.T.) 
Set(_SET_PRINTER,lPrinterOn) 
Set(_SET_CONSOLE,lConsole) 
Set(_SET_DEVICE,cDevice) 
Return nChoice 
