/*
 This is SuccessWare's raw functions with some minor changes I made.
 It is not perfect but it will work with the Six stuff. I made it
 return the current scroll so I could implement nested browses.
 Lots of ways to do this but this should give you some basics.
 I make the first call with the coordinates and a .f. so it
 doesn't display ahead of the rest of my window.

   ShowScrollBar() - This function displays a simple vertical "scroll bar"
                     for a TBrowse on the current table and index.  Call
                     ShowScrollBar() with scroll bar screen coordinates to
                     initialize it, then with no parameters to update it.
                     Static variables are used to keep track of screen
                     coordinates and step value.  Called from Main().
*/

FUNC ShowScrollBar( pArray , lDisplay )
// parameter is an array of nTop, nLeft, nBottom, nRight

    static nBarTop, nBarLeft, nBarBottom, nBarRight, nBarWidth
    static nKeyStep, nKeys

    LOCAL  nPos
    LOCAL i
    LOCAL keyno
    LOCAL aReturn := { nBarTop , nBarLeft , nBarBottom , nBarRight }

    // Did we get coordinates?
    IF pArray # NIL
        // Yes, initialize...

        // Set the bar coordinates
        nBarTop    := pArray[1] //nTop
        nBarLeft   := pArray[2] //nLeft
        nBarBottom := pArray[3] //nBottom
        nBarRight  := pArray[4] //nRight
        nBarWidth  := (nBarRight - nBarLeft) + 1

    ENDIF

    // default is to display the scroll bar
    If lDisplay = NIL .or. lDisplay

        // Get number of keys in current index
        nKeys    := Sx_KeyCount()

        // Calculate the number of keys to skip before moving "elevator"
        If nKeys < (nBarBottom - nBarTop )
           nKeyStep := INT((nBarBottom - nBarTop) / nKeys )
        Else
           nKeyStep := INT(nKeys / (nBarBottom - nBarTop))
        Endif
        nKeyStep := If(nKeyStep = 0 , 1 , nKeyStep)

       // Clear the scroll bar
       For i = nBarTop to nBarBottom
          @ i,nBarLeft SAY REPLICATE(Chr(176),nBarWidth) color clr4
       Next

       // Draw the "elevator"
       keyno := Sx_Keyno()
       If keyno = 1
          nPos := nBartop
       Elseif keyno = nKeys
          nPos := nBarBottom
       Elseif nKeys < (nBarBottom - nBarTop )
          nPos := MIN(nBarTop + ( (keyno - 1) * nKeyStep), nBarBottom)
       Else
          nPos := MIN(nBarTop + (  keyno / nKeyStep), nBarBottom)
       Endif
       @ nPos,nBarLeft SAY REPLICATE(chr(254),nBarWidth) Color clr4

    Endif
RETURN aReturn
