
Thanks for the code you sent to Michael Koh!  I've modified it to run under 
5.01 using the standard ntx driver and the NTXREC/NTXPOS functions.  I've also 
noted the changes that have to be made when calling those functions to allow 
for changes in the internals for 5.2.


 /*
    ShowScrollBar() - This function displays a simple vertical "scroll bar"
                      for a TBrowse on the current table and index.  Call
                      ShowScrollBar() with scroll bar screen coordinates to
                      initialize it, then with no parameters to update it.
                      Static variables are used to keep track of screen
                      coordinates and step value.  Called from Main().
 */
 /*
    Modified yo work with the standard DBFNTX RDD.  Modifeid version
    requires NTXPOS from the ClipNet archive NTX2.ARJ.
 */
 FUNC ShowScrollBar( pArray , lDisplay )
 // parameter is an array of nTop, nLeft, nBottom, nRight

     static nBarTop, nBarLeft, nBarBottom, nBarRight, nBarWidth
     static nKeyStep, nKeys
     LOCAL  nPos
     LOCAL i
     LOCAL keyno
     LOCAL aReturn := { nBarTop , nBarLeft , nBarBottom , nBarRight }
     LOCAL nHere
     // Did we get coordinates?
     IF pArray # NIL
         // Yes, initialize...

         // Set the bar coordinates
         nBarTop    := pArray[1] //nTop
         nBarLeft   := pArray[2] //nLeft
         nBarBottom := pArray[3] //nBottom
         nBarRight  := pArray[4] //nRight
         nBarWidth  := (nBarRight - nBarLeft) + 1
     ENDIF

     // default is to display the scroll bar
     If lDisplay = NIL .or. lDisplay

         // Get number of keys in current index
         // nKeys    := Sx_KeyCount()
         // Counting records with NTX is a PITA
         nKeys := 0                  // Can handle the new NTX RDD
         nHere := recno()
         dbeval( {|| nKeys := nKeys + 1 } )
         dbGoTo( nHere )              // Leave the dB as I found it
         // Calculate the number of keys to skip before moving "elevator"
         If nKeys < (nBarBottom - nBarTop )
            nKeyStep := INT((nBarBottom - nBarTop) / nKeys )
         Else
            nKeyStep := INT(nKeys / (nBarBottom - nBarTop))
         Endif
         nKeyStep := If(nKeyStep = 0 , 1 , nKeyStep)

        // Clear the scroll bar
        For i = nBarTop to nBarBottom
           @ i,nBarLeft SAY REPLICATE(Chr(176),nBarWidth) color clr4
        Next

        // Draw the "elevator"
        // keyno := Sx_Keyno()
        keyno := NTXPOS( IndexOrd(), RECNO() )     // For 5.01a
        /*
          The location of the index file handle has been moved in the
          undocumented internal workspace in 5.2.
        */
 *       keyno := NTXPOS( IndexOrd() + 2, RECNO() )     // For 5.2a
        If keyno = 1
          nPos := nBartop
        Elseif keyno = nKeys
          nPos := nBarBottom
        Elseif nKeys < (nBarBottom - nBarTop )
           nPos := MIN(nBarTop + ( (keyno - 1) * nKeyStep), nBarBottom)
        Else
           nPos := MIN(nBarTop + (  keyno / nKeyStep), nBarBottom)
        Endif
        @ nPos,nBarLeft SAY REPLICATE(chr(254),nBarWidth) Color clr4

     Endif
 RETURN aReturn

That way, by commenting out the line I've marked with "// For 5.01a" and 
including the line I've marked with "// For 5.2a", you can use this same 
function in 5.2a and avoid what appears to be the main VMIEF culprit.
