/*
    OPENLIST.PRG
    Author: Phil Barnett (Clipper Echo)
    Modified by E. Givler 3/15/93
    Calls: name2hdl() - ASM function.

*/
FUNCTION open_list
local x, indx
local crlf   := chr(13)+chr(10)
local hndls  := 0
local txt    := ''
local inarea := SELECT()
local inscr  := savescreen(0,0,24,79)
local cidxname, nHand

    // Step through the work areas.
    FOR x := 1 TO 250

        IF ! empty(ALIAS(x))

            SELECT( x )
            txt += 'Area  : ' + STR(x,3) + ;
                   IF(x==inarea,' (Active) ','') + crlf
            txt += 'Alias : ' + ALIAS() + crlf
            txt += 'Handle: ' + STR( name2hdl(PADR( alias(), 8) + 'DBF'),3) + crlf
            txt += replicate(CHR(196),25)+crlf
            hndls++
            indx := 1

            // List index keys for this area.
            DO WHILE ! EMPTY( OrdName( indx ) )
                cidxname := UPPER(PADR(OrdName( indx ),8) + RIGHT( OrdBagExt(), 3))
                txt += 'Index : ' + OrdName( indx ) + OrdBagExt() + CRLF
                txt += '  Key : ' + indexkey(indx) + crlf
                txt += 'Handle: ' + STR(name2hdl( cIdxname ), 3) + CRLF
                indx++
                hndls++
            ENDDO
            txt += replicate(CHR(205),77)+crlf
        ENDIF

    NEXT x
    txt += 'DBF/NTX Handles used = '+STR(hndls,3)

    dispbox(0,0,24,79)
    memoedit(txt,1,1,23,78)
    SELECT(inarea)
    restscreen(0,0,24,79,inscr)

    if (nHand := fcreate('handles.log') ) != -1
         fwrite(nHand, txt )
         fclose( nHand )
    endif

RETURN NIL
