;_____________________________________________________________________________
;
;           Author: Terry Carmen
; Released to the Public Domain 3/11/1993
;_____________________________________________________________________________
;
;
;     Program Name:   name2hdl.asm
;        $Revision:   1.1  $
;            $Date:   11 Mar 1993 13:47:20  $
;
;
;
; Revision History:
;             $Log:   E:/logfiles/shoptrak/name2hdl.asv  $
;
;     Rev 1.1   11 Mar 1993 13:47:20
;  Improved comments and released to PD
;
;     Rev 1.0   12 Dec 1992  2:18:06
;  Initial Revision
;
;_____________________________________________________________________________


;Clipper callable function to return the handle when given the filename.
; This function uses no Clipper internals and gets the handle information
; from DOSs Job File Table

; Note that it is unaware of paths, and you will confuse it if you have
; the same filename open in multiple directories at the same time.
; This shouldn't be a big problem

;  usage:   cName:="CUST    DBF"
;           nHandle:=name2hdl(cName)

;  note that the name ;must; be exactly 11 characters wide, and contain
;  no punctuation, and have the filename flush left and the
;  extention flush right.

; assemble with TASM /mx /w2 name2hdl


public name2hdl

extrn   __parc:far
extrn   __parinfo:far
extrn   __parclen:far
extrn   __retni:far
extrn   __ret:far

assume cs:_prog, ds:nothing, es:nothing

dgroup  group   datasg
datasg  segment public  para 'DATA'

        namebuff   db 11 dup (' ')

datasg ends

_prog segment 'CODE'

name2hdl proc    far

        push    bp
        mov     bp,sp
        push    ds
        push    es
        push    si
        push    di

        mov     ax, 0
        push    ax
        call    __parinfo           ; how many params?
        add     sp,2
        cmp     al,1                ; should be 1
        jne     @@bad_exit          ; if not, we're out of here..


        mov     ax, 1               ; check the type
        push    ax
        call    __parinfo
        add     sp,2
        and     ax,1                ; is it a string?
        cmp     ax, 1
        jne     @@bad_exit          ; if not, we're out of here..

        mov     ax, 1
        push    ax
        call    __parclen           ; how big is the string?
        add     sp,2
        cmp     ax, 11
        jne     @@bad_exit

        mov     ax, 1
        push    ax
        call    __parc              ; where is the string?
        add     sp,2                ; address in DX:AX

        mov     ds, dx              ; point ds:si to Clipper's string
        mov     si, ax

        mov     ax, seg datasg       ; point es: to our buffer
        mov     es, ax

        cld
        mov     al, ' '
        mov     cx, 11
        mov     di, offset namebuff
        rep stosb         ; al -> es:di   clear our buffer

        mov     cx, 11
        mov     di, offset namebuff
        rep movsb         ; ds:si -> es:di copy string to our buffer

        mov     bx,0                ; start with handle 1

@@next_handle:

        inc     bx
        push    bx
        mov     ah,12h              ; get JFT number
        mov     al,20h              ; ES:DI will point to JFT
        int     2Fh                 ; byte pointed at has SFT number
        jc      @@bad_exit

        xor     bh,bh                   ; BX must contain SFT
        mov     bl, byte ptr es:[di]    ; for this call
        mov     ah,12h                  ; get SFT table for this file
        mov     al,16h                  ; return address of SFT in ES:DI
        int     2fh

        add     di,20h                  ; point es:[di] to file name in SFT


        mov     ax, seg namebuff       ; point ds:si to our buffer
        mov     ds, ax
        mov     si, offset namebuff
        mov     cx, 11

        cld
        mov cx, 11                      ; 11 byte filename
        rep cmpsb                       ; compare ds:si -> es:di
        je @@good_exit

        pop bx                          ; because we pushed it at the top
                                        ; of the loop
        jmp short @@next_handle


@@bad_exit:

       pop   bx ; because we pushed it at the top of the loop
       call __ret                  ; return NIL
       jmp short @@pop_regs


 @@good_exit:                      ; we already pushed BX in the
                                   ; top of the loop
   mov    ax, seg dgroup           ; point ds to Clipper's dataseg
   mov    ds, ax                   ; so it doesn't get all confused
   call __retni                    ; send the data back to Clipper
   add    sp,2                     ; fix the stack

@@pop_regs:

       pop    di
       pop    si
       pop    es
       pop    ds
       pop    bp
       Ret

name2hdl endp
ends
end


;****************end of source code***********************
