;If you have Turbo Assembler or MASM, here's a Clipper callable
;generic mouse driver interface.
;
;You can make *any* mouse call you want via the MsDriver()
;function and then query the results via the MsAX(), MsBX(),
;MsCX(), and MsDX() functions (the Microsoft Mouse Programmer's
;Reference would be handy).  A Clipper 5.0x source code module,
;containing some useful functions, follows in the next message.
;
;The text "-=[ End of Message ]=-" marks the end of each message
;- if you don't see it, something ate the message.
; MOUSE.ASM
;
; Microsoft Mouse Driver Interface for Clipper.
;
; This code is an original work placed into the public domain by
; the author, Todd C. MacDonald.
;
; Assemble with "TASM MOUSE".

PUBLIC MsDriver, MsAX, MsBX, MsCX, MsDX

EXTRN   __parni         : FAR
EXTRN   __retni         : FAR

MS_INT  equ     33H

DGROUP GROUP    data

data    SEGMENT PUBLIC  'DATA'

        ValAX   DW 0
        ValBX   DW 0
        ValCX   DW 0
        ValDX   DW 0

data    ENDS

code    SEGMENT 'CODE'
        ASSUME cs:code, ds:DGROUP


; /-------------------------------------------------------------\
; | MsDriver                                                    |
; \-------------------------------------------------------------/

MsDriver        PROC    FAR

        ; save registers
        push    ds
        push    es
        push    si
        push    di

        ; push 4th parameter onto stack
        mov     ax, 4
        push    ax
        call    __parni
        add     sp, 2
        push    ax

        ; push 3rd parameter onto stack
        mov     ax, 3
        push    ax
        call    __parni
        add     sp, 2
        push    ax

        ; push 2nd parameter onto stack
        mov     ax, 2
        push    ax
        call    __parni
        add     sp, 2
        push    ax

        ; put 1st parameter (mouse function number) in ax
        mov     ax, 1
        push    ax
        call    __parni
        add     sp, 2

        ; put 2nd, 3rd, 4th parameters into BX, CX, and DX
        pop     bx
        pop     cx
        pop     dx

        int     MS_INT

        ; store results
        mov     ValAX, ax
        mov     ValBX, bx
        mov     ValCX, cx
        mov     ValDX, dx

        ; restore registers
        pop     di
        pop     si
        pop     es
        pop     ds

        ret

MsDriver        ENDP


; /-------------------------------------------------------------\
; | MsAX                                                        |
; \-------------------------------------------------------------/

MsAX    PROC    FAR

        ; save important registers
        push    ds
        push    es
        push    si
        push    di

        ; return ValAX to Clipper
        mov     ax, ValAX
        push    ax
        call    __retni
        add     sp, 2

        ; restore registers
        pop     di
        pop     si
        pop     es
        pop     ds

        ret

MsAX    ENDP


; /-------------------------------------------------------------\
; | MsBX                                                        |
; \-------------------------------------------------------------/

MsBX    PROC    FAR

        ; save important registers
        push    ds
        push    es
        push    si
        push    di

        ; return ValBX to Clipper
        mov     ax, ValBX
        push    ax
        call    __retni
        add     sp, 2

        ; restore registers
        pop     di
        pop     si
        pop     es
        pop     ds

        ret

MsBX    ENDP


; /-------------------------------------------------------------\
; | MsCX                                                        |
; \-------------------------------------------------------------/

MsCX    PROC    FAR

        ; save important registers
        push    ds
        push    es
        push    si
        push    di

        ; return ValCX to Clipper
        mov     ax, ValCX
        push    ax
        call    __retni
        add     sp, 2

        ; restore registers
        pop     di
        pop     si
        pop     es
        pop     ds

        ret

MsCX    ENDP


; /-------------------------------------------------------------\
; | MsDX                                                        |
; \-------------------------------------------------------------/

MsDX    PROC    FAR

        ; save important registers
        push    ds
        push    es
        push    si
        push    di

        ; return ValDX to Clipper
        mov     ax, ValDX
        push    ax
        call    __retni
        add     sp, 2

        ; restore registers
        pop     di
        pop     si
        pop     es
        pop     ds

        ret

MsDX    ENDP

code    ENDS

        END
