// Here's the Clipper source module for use with MOUSE.ASM:
// MINNIE.PRG
//
// Microsoft Mouse Driver Interface Routines for Clipper 5.0x.
//
// This code is an original work placed into the public domain by
// the author, Todd C. MacDonald.
//
// Assemble the Mouse Driver Interface with "TASM MOUSE".
//
// Compile this module with "CLIPPER MINNIE /N /W /DTEST".  Drop
// the "/DTEST" when you're ready to link it into your app.
//
// Link with "BLINKER FI MINNIE, MOUSE".


#define K_MS_LEFT       -97
#define K_MS_RIGHT      -98
#define K_MS_BOTH       -99

#define MS_RESET        0
#define MS_SHOW         1
#define MS_HIDE         2
#define MS_READ         3
#define MS_SET_POS      4
#define MS_SET_HORIZ    7
#define MS_SET_VERT     8
#define MS_SET_CURS     10

#define MS_CURS_WIDTH   8
#define MS_CURS_HEIGHT  8


STATIC lActive    := .f.
STATIC lVisible   := .f.
STATIC lLpressed  := .f.
STATIC lRpressed  := .f.
STATIC nNbrButtns := 0
STATIC nLastkey   := 0
STATIC nRow       := 0
STATIC nCol       := 0


#IFDEF TEST


#include "inkey.ch"


//-------------------------------------------------------------//
  FUNCTION Test
//-------------------------------------------------------------//

LOCAL GetList := {}
LOCAL nKey

MsInit()
MsSetCurs( 65280, 4 )
MsSetBound( 0, 0, maxrow(), maxcol() )

clear

IF MsActive()

  @ 0, 0 say 'Row:     Col:     Left Button:          ' + ;
    'Right Button:          Visible:'

  @ 1, 0, maxrow() - 1, maxcol() - 1 box 'Ŀ '

  MsSetBound( 2, 1, maxrow() - 2, maxcol() - 2 )
  MsSetPos( 2, 1 )
  MsShow()

  nKey := MsInkey()

  WHILE nKey != K_ESC

    IF nKey = K_MS_LEFT

      IF !MsVisible()

        MsShow()

      ENDIF

    ELSEIF nKey = K_MS_RIGHT

      IF MsVisible()

        MsHide()

      ENDIF

    ENDIF

    @ 0,5  say MsRow() pict '99'
    @ 0,14 say MsCol() pict '99'
    @ 0,31 say iif( MsLpressed(), 'Pressed', '       ' )
    @ 0,54 say iif( MsRpressed(), 'Pressed', '       ' )
    @ 0,72 say iif( MsVisible(), 'Yes', 'No ' )

    nKey := MsInkey()

  END

  MsHide()

ENDIF

MsHide()

RETURN nil
//-------------------------------------------------------------//


#ENDIF


//-------------------------------------------------------------//
  FUNCTION MsInit()
//-------------------------------------------------------------//

MsDriver( MS_RESET )

nNbrButtns := MsBX()
lActive    := ( MsAX() = -1 )

RETURN nil
//-------------------------------------------------------------//


//-------------------------------------------------------------//
  FUNCTION MsShow()
//-------------------------------------------------------------//

MsDriver( MS_SHOW )

lVisible := .t.

RETURN nil
//-------------------------------------------------------------//


//-------------------------------------------------------------//
  FUNCTION MsHide()
//-------------------------------------------------------------//

MsDriver( MS_HIDE )

lVisible := .f.

RETURN nil
//-------------------------------------------------------------//


//-------------------------------------------------------------//
  FUNCTION MsSetPos( nRow, nCol )
//-------------------------------------------------------------//

MsDriver( MS_SET_POS, 0, nCol * MS_CURS_WIDTH, nRow * ;
  MS_CURS_HEIGHT )

RETURN nil
//-------------------------------------------------------------//


//-------------------------------------------------------------//
  FUNCTION MsSetBound( nT, nL, nB, nR )
//-------------------------------------------------------------//

MsDriver( MS_SET_HORIZ, 0, nL * MS_CURS_WIDTH,  nR * ;
  MS_CURS_WIDTH  )

MsDriver( MS_SET_VERT,  0, nT * MS_CURS_HEIGHT, nB * ;
  MS_CURS_HEIGHT )

RETURN nil
//-------------------------------------------------------------//


//-------------------------------------------------------------//
  FUNCTION MsSetCurs( nScrnMask, nCursMask )
//-------------------------------------------------------------//

MsDriver( MS_SET_CURS, 0, nScrnMask, nCursMask )

RETURN nil
//-------------------------------------------------------------//


//-------------------------------------------------------------//
  FUNCTION MsRead()
//-------------------------------------------------------------//

MsDriver( MS_READ )

lLpressed := ( MsBX() = 1 ) .or. ( MsBX() = 3 )
lRpressed := ( MsBX() = 2 ) .or. ( MsBX() = 3 )

nRow      := MsDX() / MS_CURS_HEIGHT
nCol      := MsCX() / MS_CURS_WIDTH

RETURN nil
//-------------------------------------------------------------//


//-------------------------------------------------------------//
  FUNCTION MsInkey( nDelaySecs )
//-------------------------------------------------------------//

LOCAL nSecs := seconds()
LOCAL lExit := .f.
LOCAL nKey  := 0

nDelaySecs := if( valtype( nDelaySecs ) = 'N', nDelaySecs, -1 )

WHILE !lExit

  nKey := inkey()

  IF nKey != 0

    lExit := .t.

  ELSE

    IF lActive

      MsRead()

      IF lLpressed .and. lRpressed

        nKey  := nLastKey := K_MS_BOTH
        lExit := .t.

      ELSEIF lLpressed

        nKey  := nLastKey := K_MS_LEFT
        lExit := .t.

      ELSEIF lRpressed

        nKey  := nLastKey := K_MS_RIGHT
        lExit := .t.

      ENDIF

    ENDIF

  ENDIF

  IF nDelaySecs != 0

    IF seconds() - nSecs > nDelaySecs

      lExit := .t.

    ENDIF

  ENDIF

END

RETURN nKey
//-------------------------------------------------------------//


//-------------------------------------------------------------//
  FUNCTION MsActive()
//-------------------------------------------------------------//

RETURN lActive
//-------------------------------------------------------------//


//-------------------------------------------------------------//
  FUNCTION MsVisible()
//-------------------------------------------------------------//

RETURN lVisible
//-------------------------------------------------------------//


//-------------------------------------------------------------//
  FUNCTION MsLpressed()
//-------------------------------------------------------------//

RETURN lLpressed
//-------------------------------------------------------------//


//-------------------------------------------------------------//
  FUNCTION MsRpressed()
//-------------------------------------------------------------//

RETURN lRpressed
//-------------------------------------------------------------//


//-------------------------------------------------------------//
  FUNCTION MsRow()
//-------------------------------------------------------------//

RETURN nRow
//-------------------------------------------------------------//


//-------------------------------------------------------------//
  FUNCTION MsCol()
//-------------------------------------------------------------//

RETURN nCol
//-------------------------------------------------------------//


//-------------------------------------------------------------//
  FUNCTION MsLastKey()
//-------------------------------------------------------------//

RETURN nLastKey
//-------------------------------------------------------------//
