;**************************************
;Filename: fisdir.asm,.obj
;Purpose: To check to see if a specified directory path is valid
;Usage: ISDIR(expc)
;       where expc is a variable or literal string containing
;       a directory path
;Returns: Logical true if the directory exists or false if it does ;not.
;Notes: The program receives a parameter from a Clipper program ;containing
;       the directory path to be validated. It saves that ;segment:offset
;       pair in ES and CX. It then gets the current directory path and ;saves
;       it to the dir_buff. An attempt is made to change to the ;directory
;       path being validated. If it is successful a true value is ;passed back
;       to the Clipper program and the program changes back to the ;original
;       directory. Otherwise, it returns false.
;Copyright (c) 1988 Nantucket Corporation.
;**************************************


PUBLIC          ISDIR

EXTRN           __PARC:FAR
EXTRN           __RETL:FAR


CODESEG          SEGMENT BYTE    'CODE' ;PROG IS THE REQUIRED CLASS CODE
                 ASSUME  CS:CODESEG     ;     FOR AUTUMN 86 CLIPPER

ISDIR   PROC    FAR

; INITIALIZATION PROCEDURE OF SAVING THE BASE POINTER AND REGISTERS
        PUSH    BP
        MOV     BP,SP

        PUSH    DS
        PUSH    ES
        PUSH    SI
        PUSH    DI

; GET PASSED PARAMETER
        MOV     AX,1
        PUSH    AX
        CALL    __parc
        ADD     SP,2

; SAVE ADDRESS IN ES:CX REGISTER PAIR
        MOV     ES,DX
        MOV     CX,AX

; GET CURRENT DRIVE AND SAVE INTO DRV
        MOV     AH,19H
        INT     21H
        MOV     BL,AL
        XOR     BH,BH
        MOV     AL,CS:DRV_TABLE[BX]
        MOV     CS:DRV,AL

; GET CURRENT DIRECTORY PATH NAME AND SAVE TO DIR_BUFF
        MOV     AH,47H
        MOV     DL,0
        MOV     SI,SEG DIR_BUFF
        MOV     DS,SI
        MOV     SI,OFFSET DIR_BUFF
        INT     21H

; ATTEMPT TO CHANGE TO NEW DIRECTORY
        PUSH    ES
        POP     DS
        MOV     DX,CX
        MOV     AH,3BH
        INT     21H

        MOV     CX,0    ;SET RETURN VALUE TO DEFAULT OF FALSE
        JC      NOPATH

; IF NEW DIRECTORY EXISTS SET RETURN VALUE TO TRUE AND RETURN TO ; ORIGINAL
; DIRECTORY
        MOV     CX,1
        MOV     AH,3BH
        PUSH    CS
        POP     DS
        MOV     DX,OFFSET DRV
        INT     21H

; TERMINATION PROCEDURE
NOPATH:
        POP     DI
        POP     SI
        POP     ES
        POP     DS
        POP     BP

; RETURN LOGICAL TRUE OR FALSE
        MOV     AX,CX
        PUSH    AX
        CALL    __retL
        POP     AX
        RET
ISDIR           ENDP

DRV_TABLE       DB      "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
DRV             DB      ?
COLON           DB      ':'
BK_SLASH        DB      '\'
DIR_BUFF        DB      65 DUP(0)


CODESEG         ENDS
                END
