FUNCTION FillBrowse( oBrowse )
/*
Last modified: 04-27-93 09:37am
Forces all data rows in a tbrowse display to be filled with data
(provided enough is available in the data source).  The browse
cursor will stay with the current record even if the record's
row position changes.

Authors: Todd MacDonald and Shane Hall
Recommended usage:
  dispbegin()
  FillBrowse( oBrowse )
  dispend()
*/

LOCAL nMoved := 0  // keeps track of where original record is
LOCAL nScroll      // number of records to scroll up
LOCAL n            // loop counter
// save autoLite status and turn off hilite to prevent "sticky"
// cursor and speed up stabilization.
LOCAL lSavAutoL  := oBrowse:autoLite

     oBrowse:autoLite := .f.
     oBrowse:deHilite()
     oBrowse:ForceStable()        // WHILE !oBrowse:stabilize(); END

     // try to move the pointer to the bottom row of the display
     WHILE oBrowse:rowPos < oBrowse:rowCount .and. !oBrowse:hitBottom
          oBrowse:down()
          oBrowse:ForceStable()      // WHILE !oBrowse:stabilize(); END
          nMoved++
     END

     // if we hit bottom, then there are 1 or more blank rows
    IF oBrowse:hitBottom
          // calculate number of records to scroll up past the top row
          nScroll := oBrowse:rowCount - oBrowse:rowPos
          // keep track of where the original record is
          nMoved -= oBrowse:rowPos
          // go to the top row
          oBrowse:rowPos := 1

          // attempt to scroll up the appropriate number of records
          FOR n := 1 TO nScroll
               oBrowse:up()
               oBrowse:ForceStable()      // WHILE !oBrowse:stabilize(); END
               IF !oBrowse:hitTop
                    nMoved--
               ELSE
                    EXIT
               ENDIF
          NEXT n

          // put pointer back on original record
          FOR n := 1 TO -nMoved
               oBrowse:down()
          NEXT n

     // we didn't hit bottom so the display is already filled
     ELSE

          // put pointer back on original record
          FOR n := 1 TO nMoved
               oBrowse:up()
          NEXT n

     ENDIF

     oBrowse:ForceStable()             // WHILE !oBrowse:stabilize(); END
     // turn hilite on and restore autoLite status
     oBrowse:hilite()
     oBrowse:autoLite := lSavAutoL

RETURN NIL
