/***************************************************************************

    FILEOUT.PRG

    EXAMPLE SYNTAX: CAPFIRST.OBJ CAPFIRST.HEX

    FILEOUT takes a file, any file, (OBJ, LIB, EXE, COM) and creates
    an output hex dump file that can be read by FILEIN.PRG to
    recreate the original file.

    This should allow you to transfer any DOS file as a text file
    over any E-MAIL system and then re-create it on the receiving
    end.  Keep in mind that your HEX dump file will be TWICE as
    big as the original file.  I wouldn't recommend transfering
    Clipper EXE's to Germany with this util.

    My apologies to SYSOPS all over the world!

    Compile with: -m -n
    Link With   : whatever

    Kirby L. Wallace
    120 N. Sandusky Ave.
    Tulsa, OK.  74115

    RELEASED TO THE PUBLIC DOMAIN: March 1993

***************************************************************************/

#include "fileio.ch"
#define  LF CHR(13)+CHR(10)

****************************************************************************
FUNCTION FileOut( cInFile, cOutFile )

LOCAL   nIHandle, nOHandle
LOCAL   nInputEnd
LOCAL   cByte := ' ', i

BEGIN SEQUENCE

    if !file(cInFile)
        ?
        ? 'Input File Not Found: '+cInFIle
        BREAK

    endif

    nOHandle = fcreate(cOutFile)

    if ferror() != 0
        ?
        ? 'Output File Create Error: '+cOutFile
        BREAK
    endif

    nIHandle = fopen(cInFile)

    if ferror() != 0
        ?
        ? 'Input File Open Error: '+cInFile
        BREAK
    endif

    nInputEnd = fseek(nIHandle,0,FS_END) ; fseek(nIHandle,0,FS_SET)

    i = 0

    while .t.

        if fread(nIHandle,@cByte,1) != 1
            ? 'Done...'
            BREAK
        endif


        fwrite(nOHandle,_IToH(asc(cByte)),2)
        i++

        if i = 35
            fwrite(nOHandle,LF,2)
            i = 0
        endif

    end

END SEQUENCE

fclose(nIHandle) ; fclose(nOHandle)

RETURN(NIL)

****************************************************************************
FUNCTION _IToH(nInteger)
LOCAL    i
LOCAL    j
LOCAL    cHexOut := ""
LOCAL    aHexPosVal := {1,16,256}
LOCAL    cHex := repl('0',len(aHexPosVal))


// indenting reduced to fit message base size
// you may want to re-indent to suit your needs

for i = len(aHexPosVal) to 1 STEP -1

 for j = 16 to 1 STEP -1

   if aHexPosVal[i] * j <= nInteger

     cHex = stuff(cHex,i,1,iif(j > 9, substr('ABCDEF',j-9,1),ltrim(str(j))))
     nInteger -= (aHexPosVal[i] * j)

     exit

   endif

 next

next

for i = len(cHex) to 1 STEP -1
    if substr(cHex,i,1) != '0'
        j = i
        exit
    endif

next

for i = j to 1 STEP -1
    cHexOut += substr(cHex,i,1)
next


cHexOut = repl('0',2-len(cHexOut))+cHexOut

RETURN(cHexOut)
