/***************************************************************************

    FileIn.PRG

    EXAMPLE SYNTAX: FILEIN CAPFIRST.HEX CAPFIRST.OBJ

    FILEIN Takes a HEX text file and converts it to it's DOS file
    equivelent.  The HEX text file MUST have been created with
    FILEOUT.PRG.

    For instance, if CAPFIRST.HEX contains a HEX dump of CAPFIRST.OBJ
    then to create CAPFIRST.OBJ from CAPFIRST.HEX, enter:

        FILEIN CAPFIRST.HEX CAPFIRST.OBJ

    For this example, cut the HEX dump that follows (in a following
    message) into it's own file (name it what you will).  Cut it exactly
    at the lines it begins and ends on.

    You can then use the resulting CAPFIRST.OBJ as a valid Object
    File, just like any other.

    Compile with: -m -n
    Link With   : whatever

    Kirby L. Wallace
    120 N. Sandusky Ave.
    Tulsa, OK.  74115

    RELEASED TO THE PUBLIC DOMAIN: March 1993

***************************************************************************/

#include "fileio.ch"
#define  MAXCHARS 1024
#define  LF CHR(13)+CHR(10)

****************************************************************************
FUNCTION FileIn( cInFile, cOutFile )

LOCAL   nIHandle, nOHandle
LOCAL   cByte := ' ', i
LOCAL   cThisLine

BEGIN SEQUENCE

    if !file(cInFile)
        ?
        ? 'Input File Not Found: '+cInFIle
        BREAK

    endif

    nOHandle = fcreate(cOutFile)

    if ferror() != 0
        ?
        ? 'Output File Create Error: '+cOutFile
        BREAK
    endif

    nIHandle = fopen(cInFile)

    if ferror() != 0
        ?
        ? 'Input File Open Error: '+cInFile
        BREAK
    endif

    while !_FEOF(nIHandle)

        cThisLine = _ReadLine(nIHandle)

        for i = 1 to len(cThisLine) STEP 2
            fwrite(nOHandle,chr(_HToI(substr(cThisLine,i,2))))
        next

    end


END SEQUENCE

fclose(nIHandle) ; fclose(nOHandle)

RETURN(NIL)

****************************************************************************
FUNCTION _ReadLine(nHandle,nLength)
LOCAL    cRet_Val := ''
LOCAL    cCharBuffer
LOCAL    nPointer
LOCAL    nChars_Read
LOCAL    nLineFeedAt

cCharBuffer = space(iif(nLength = NIL,MAXCHARS,nLength))
nLength     = iif(nLength = NIL,MAXCHARS,nLength)

BEGIN SEQUENCE

    // note current position
    nPointer = fseek(nHandle,0,FS_RELATIVE)

    (nChars_Read := fread(nHandle,@cCharBuffer,nLength))

    if ( nLineFeedAt := at(LF,cCharBuffer) ) > 0

        // got a line with Line Feed, ELSE return all of what we read

        cRet_Val = substr(cCharBuffer,1,nLineFeedAt-1)

        // reset pointer to next line
        fseek(nHandle,nPointer,FS_SET)
        fseek(nHandle,nPointer+nLineFeedAt+1,FS_SET) // 2 = crlf pair

    else

        cRet_Val = substr(cCharBuffer,1,nLength)

    endif

END SEQUENCE

RETURN(trim(cRet_Val))

****************************************************************************
FUNCTION _FEOF(nHandle)
LOCAL nCurrentPointer := fseek(nHandle,0,FS_RELATIVE)
LOCAL nEOFPosition := fseek(nHandle,0,FS_END)
LOCAL k := ' '

fseek(nHandle,nCurrentPointer,FS_SET) // reset pointer to original position

RETURN(iif(nCurrentPointer >= nEOFPosition,.t.,.f.))




****************************************************************************
FUNCTION _HToI(cVar)
LOCAL    nInt := 0
LOCAL    i
LOCAL    nVal

for i = 1 to len(cVar)
     if upper(substr(cVar,i,1)) $ 'ABCDEF'
         nVal = 9 + _ap(substr(cVar,i,1))
     else
         nVal = val(substr(cVar,i,1))
     endif

     nInt += nVal * _to_power(16,len(cVar)-i)

next

RETURN(nInt)


****************************************************************************
FUNCTION _AP(cAp_Char)
RETURN(iif(cAp_Char=NIL,0,at(lower(cAp_Char),'abcdefghijklmnopqrstuvwxyz')))


****************************************************************************
FUNCTION _To_Power(nNum1, nNum2)
LOCAL    nNum3, i

do case

    case nNum2 == 0
        nNum3 = 1

    case nNum2 == 1
        nNum3 = nNum1

    case nNum2 > 0
         nNum3 = 1

         for i = 1 to nNum2
             nNum3 *= nNum1
         next

    case nNum2 < 0
        nNum3 = 0.000000 + nNum1

        for i = 0 to nNum2 STEP -1
            nNum3 /= nNum1
        next

endcase

RETURN(nNum3)
