/*
 * File......: BTOC.PRG
 * Author....: Glenn Scott
 * CIS ID....: 71620,1521
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Glenn Scott and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "netto.ch"

/*  $DOC$
 *  $FUNCNAME$
 *     FN_BTOC()
 *  $CATEGORY$
 *     Message
 *  $ONELINER$
 *     Broadcast to file server console
 *  $SYNTAX$
 *
 *     fn_btoc( cMsg ) -> lSuccess
 *
 *  $ARGUMENTS$
 *
 *    <cMsg>, a character string representing the message you want
 *    to send to the file server console.  Can be no longer than 
 *    60 characters.
 *
 *  $RETURNS$
 *
 *    Logical TRUE (.t.) if the call succeeds; FALSE (.f.) if it 
 *    doesn't.  If it fails, you can check fn_error() for one of
 *    the following:
 *
 *         252      Message queue is full
 *         254      I/O failure due to lack of "dynamic workspace",
 *                  whatever that means.  Isn't it enough to know
 *                  it just didn't work?
 *
 *  $DESCRIPTION$
 *     
 *   Use this call to send a broadcast message to the file server
 *   console.  This sends to the default server's console.
 *   This would be useful for auditing, or for alerting the 
 *   file server operator ("Load the backup tape!") or something
 *   of that nature.
 *
 *   Good for letting network supervisors know your powerful 
 *   Clipper app is running yet again.
 *
 *  $EXAMPLES$
 *
 *       fn_btoc( "Warning: Someone is using a Clipper app" )
 *       
 *  $INCLUDE$
 *
 *  $SEEALSO$
 *     FN_SBM()
 *  $END$
 */


function fn_btoc( cMsg )
  local cReq, cRep

  default cMsg to "[netto]"
  cMsg := iif( len( cMsg ) >= 60, subs( cMsg, 1, 60 ), cMsg )

  cReq := I2BYTE( 9 ) + I2BYTE( len( cMsg ) ) + cMsg
  cRep := ""

  return ( _fnReq( 225, cReq, @cRep ) == 0 )


