/*
 * File......: SACCHLD.PRG
 * Author....: Joseph D. Booth
 * CIS ID....: 72040,2112
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Joseph D. Booth and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     FN_sAccHold()
 *  $CATEGORY$
 *     Accounting
 *  $ONELINER$
 *     Submit a hold request to an Object's account
 *  $SYNTAX$
 *     nResult := FN_sAccHold( cObjName,nObjType,nHold_Amt )
 *
 *  $ARGUMENTS$
 *     <cObjName> is the name of the bindery object to request a hold against.
 *                Wildcards cannot be used.
 *     <nObjType> is the object type of the bindery object being held..
 *     <nHoldAmt> is the amount of the hold to request.
 *
 *  $RETURNS$
 *
 *      <nResult> is numeric value indicating the status of the request
 *
 *                  0   = Successful
 *                192   = Object cannot submit charges
 *                193   = No account balance for object being charged
 *                194   = Credit limit exceeded
 *                195   = Object has too many holds
 *
 *     
 *  $DESCRIPTION$
 *     
 *  This function attempts to submit a hold to an object in the bindery.
 *  In general, when a service wants to bill another bindery object, it
 *  should submit a hold against that objects account.  The hold amount
 *  is then reserved until a charge is submitted against the account in
 *  which case the hold will be removed.  If the SUBMIT hold fails, then
 *  the service request should be denied.
 *
 *  An object can only submit charges if it's object ID is one entry
 *  in the SET property "ACCOUNT_SERVERS" on the file server where
 *  accounting is installed.
 *
 *  $EXAMPLES$
 *
 *   #define        CD_ROM_CHARGE     5.00
 *   #define        SERVER_TYPE          4
 *   #define        CONNECT_TIME         1
 *   #define        DISK_USAGE           2
 *
 *   function UseCDrom(cObject,nType)
 *   //
 *   // Assumes your software is used to access the CD-ROM attached to the
 *   // network and you charge the accounts for it's use
 *   //
 *   ok := FN_sAccHold(cObject,nType,CD_ROM_CHARGE)   // Reserve the funds
 *   if ! ok
 *      Alert( "You do not have a enough funds!!")
 *      return .F.
 *   endif
 *   //
 *   //  Allow user to browse the CD_ROM file, limited to ten minutes
 *   //
 *   FN_sAccChg(cObject,nType,SERVER_TYPE,CD_ROM_CHARGE,;
 *                      CD_ROM_CHARGE,CONNECT_TIME, ;
 *                      { 10,;         // Ten minutes being charged
 *                        100,;        // Network requests
 *                        100000,;     // 100,000 bytes read
 *                             0 } }   // 0 bytes written
 *   return .T.
 *
 *
 *  $SEEALSO$
 *      FN_gAccSta()  FN_sAccChg() FN_sAccNote()
 *  $INCLUDE$
 *
 *  $END$
 */


#include "ftint86.ch"
#include "netto.ch"

#define REQUEST_HOLD    152      /* 97h */
#define NW_ACCOUNT_CALL 227      /* E3h */


function FN_sAccHold( cObject,nType,nHoldAmt )
LOCAL cRequest, cReply, nReturn := 0

default nType to  OT_USER

cRequest := I2BYTE( REQUEST_HOLD )+;
            L2HILO( nHoldAmt )+;
            W2HILO( nType )+;
            FN_NAMEL( cObject )
cReply   := repl( chr(0), 2 )

if _fnReq( NW_ACCOUNT_CALL, cRequest, @cReply ) <> 0
   nReturn := FN_Error()
endif

return nReturn
