/*
 * File......: JOBLIST.PRG
 * Author....: Glenn Scott
 * CIS ID....: 71620,1521
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Glenn Scott and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     fn_gQJbLst()
 *  $CATEGORY$
 *     Queue
 *  $ONELINER$
 *     Get queue job list
 *  $SYNTAX$
 *
 *     fn_gQJbLst( nQueueID ) -> aJobList 
 *
 *  $ARGUMENTS$
 *
 *  $RETURNS$
 *         
 *  $DESCRIPTION$
 *
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#include "netto.ch"

#ifdef FT_TEST
  function main( cQueue )
     local nID, aList
     if pcount() == 1
        nID   := fn_gBndOID( cQueue, OT_PRINT_QUEUE )
        aList := fn_gQJbLst( nID )
        qout( "Job list for " + cQueue
        qout( " " )
        aeval( aList, { |x| qout(x) } )
     else
        qout("Usage: joblist <cQueue>")
     endif
     return nil
#endif
        

function fn_gQJbLst( nQueueID )
  local aJobList := {}, cReq, cRep, nMax, nX

  if pcount() == 1 .and. valtype( nQueueID ) == "N"
     cReq := I2BYTE( 107 ) + L2HILO( nQueueID )         // 6Bh
     cRep := repl( chr(0), 506 )
     
     if _fnReq( 227, cReq, @cRep ) == ESUCCESS
        nMax := HILO2W( subs( cRep, 1, 2 ) )
        for nX := 1 to nMax
           aadd( aJobList, HILO2W( subs( cRep, ( 2 * nX ) + 1, 2 ) ) )
        next
     endif
  else
     _fnSetErr( EBADPARM )
  endif
     
  return aJobList
