/*
 * File......: LOCKFILE.PRG
 * Author....: Glenn Scott
 * CIS ID....: 71620,1521
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Glenn Scott and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "netto.ch"
#include "ftint86.ch"

#define  NO_WAIT    0

/*  $DOC$
 *  $FUNCNAME$
 *     FN_LKFISET()
 *  $CATEGORY$
 *     Synchronization
 *  $ONELINER$
 *     Lock file set
 *  $SYNTAX$
 *
 *     fn_lkFiSet( [<nTimeout>] ) -> lSuccess
 *
 *  $ARGUMENTS$
 *
 *     <nTimeOut> is interpreted differently, depending on which 
 *     lockmode the station is currently in.
 *
 *     If the workstation is in "compatibility mode" (lock mode 0), 
 *     then:
 *         
 *                  0     =  Don't Wait  (the default)
 *         Anything else  =  Wait
 *
 *     If the workstation is in "extended lock mode" (lock mode 1),
 *     the  <nTimeOut> is optional number of 1/18th sec ticks to 
 *     wait for the lock; 0 = don't wait (default).
 *
 *  $RETURNS$
 *
 *     <lSuccess>, .t. if the call succeeded, and .f. if it didn't.
 *     If the call fails, you can check fn_error() for one of the 
 *     following:
 *
 *          If you're in compatibility mode (lock mode 0), 
 *          
 *                255      Failure 
 *
 *          If you're in extended mode (lock mode 1)
 *
 *                254      Timeout failure
 *                255      Failure
 *     
 *
 *  $DESCRIPTION$
 *
 *     Use this call after all the files to be locked have been 
 *     logged.  If this call succeeds, you've got all of them 
 *     locked.  If any file can't be locked, this call will fail
 *     and no files will have been locked.
 *
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */


function fn_lkFiSet( nTimeOut )                                // Lock file set
  local aRegs[ INT86_MAX_REGS ], lRes := .f., nCurMode

  default nTimeOut to NO_WAIT

  nCurMode = fn_getLMod()

  if valtype( nTimeOut ) == "N"

     aRegs[ AX ] := makehi( 203 )

     if nCurMode == 1
       aRegs[ BP ] := nTimeOut
     else
       aRegs[ DX ] := iif( nTimeOut != 0, 1, 0 )
     endif

     lRes := ft_int86( INT21, aRegs )
     if lRes
        if UNSIGNED( LOWBYTE( aRegs[ AX ] ) ) # 0
           _fnSetErr( UNSIGNED( LOWBYTE( aRegs[ AX ] ) ) )
           lRes := .f.
        endif
     else
        _fnSetErr( EINT86 )
     endif

  else
     _fnSetErr( EBADPARM )
  endif

  return lRes
