/*
 * File......: QJFSIZE.PRG
 * Author....: Glenn Scott
 * CIS ID....: 71620,1521
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Glenn Scott and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


#include "netto.ch"

/*  $DOC$
 *  $FUNCNAME$
 *     fn_gQJbFSz()
 *  $CATEGORY$
 *     Queue
 *  $ONELINER$
 *     Get queue job's file size
 *  $SYNTAX$
 *
 *     fn_gQJbFSz( <nQueueID>, <nJobNum> ) -> nFileSize
 *
 *  $ARGUMENTS$
 *
 *     <nQueueID> is the bindery object ID of the queue
 *     <nJobNum>  is the job number
 *
 *  $RETURNS$
 *         
 *     <nFileSize>
 *
 *  $DESCRIPTION$
 *
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

function fn_gQJbFSz( nQueueID, nJobNum )
  local cReq, cRep, nSz := 0

  if pcount() == 2 .and. ;
     valtype( nQueueID  ) == "N" .and. ;
     valtype( nJobNum   ) == "N"

     cReq := I2BYTE( 120  ) + L2HILO( nQueueID  ) + W2HILO( nJobNum )
     cRep := repl( chr(0), 10 )
     
     if  _fnReq( 227, cReq, @cRep ) == ESUCCESS
        nSz := HILO2L( subs( cRep, 7, 4 ) )
     endif

  else
     _fnSetErr( EBADPARM )
  endif

  return nSz
