/*
 * File......: MISCQ.PRG
 * Author....: Glenn Scott
 * CIS ID....: 71620,1521
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Glenn Scott and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


#include "netto.ch"

#define DESTROY     101               // 65h - don't change!
#define ATTACH      111               // 6Fh - don't change!
#define DETACH      112               // 70h - don't change!



/*  $DOC$
 *  $FUNCNAME$
 *     FN_DESTQ()
 *  $CATEGORY$
 *     Queue
 *  $ONELINER$
 *     Destroy queue
 *  $SYNTAX$
 *
 *     fn_destQ( <nQueueID> ) -> lDestroyed
 *
 *  $ARGUMENTS$
 *
 *  $RETURNS$
 *
 *  $DESCRIPTION$
 *
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

function fn_destQ( nQueueID )
  return _fnq( DESTROY, nQueueID )


/*  $DOC$
 *  $FUNCNAME$
 *     fn_atQSToQ()
 *  $CATEGORY$
 *     Queue
 *  $ONELINER$
 *     Attach queue server to queue
 *  $SYNTAX$
 *
 *     fn_atQSToQ( nQueueID ) -> lSuccess
 *
 *  $ARGUMENTS$
 *
 *     <nQueueID> is the bindery object ID of the queue
 *
 *  $RETURNS$
 *         
 *     <lSuccess>, .t. if the call succeeds.  If it doesn't, check 
 *     fn_error() for one of the following error codes:
 *
 *  $DESCRIPTION$
 *
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */


function fn_atQSToQ( nQueueID )
  return _fnq( ATTACH, nQueueID )


/*  $DOC$
 *  $FUNCNAME$
 *     fn_dtQSfQ()
 *  $CATEGORY$
 *     Queue
 *  $ONELINER$
 *     Detach queue server from queue
 *  $SYNTAX$
 *
 *     fn_dtQSfQ( nQueueID ) -> lSuccess
 *
 *  $ARGUMENTS$
 *
 *     <nQueueID> is the bindery object ID of the queue
 *
 *  $RETURNS$
 *         
 *     <lSuccess>, .t. if the call succeeds.  If it doesn't, check 
 *     fn_error() for one of the following error codes:
 *
 *  $DESCRIPTION$
 *
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */


function fn_dtQSfQ( nQueueID )
  return _fnq( DETACH, nQueueID )


/* ------------------------------------------------------------------ */


/*
 * _fnq() - Workhorse function
 *
 */

static function _fnq( nFunc, nQueueID )
  local cReq, cRep, lRes

  if pcount() == 2 .and.  valtype( nQueueID ) == "N"
     cReq := I2BYTE( nFunc )  + L2HILO( nQueueID )
     cRep := ""

     lRes := ( _fnReq( 227, cReq, @cRep ) == ESUCCESS )
  else
     _fnSetErr( EBADPARM )
  endif

  return lRes
