/*
 * File......: CFSTQJB.PRG
 * Author....: Glenn Scott
 * CIS ID....: 71620,1521
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Glenn Scott and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     FN_STQJOB()
 *  $CATEGORY$
 *     Queue
 *  $ONELINER$
 *     Close file and start queue job
 *  $SYNTAX$
 *
 *     fn_stQJob( nQueueID, nJob, nHandle ) ->lSuccess
 *
 *  $ARGUMENTS$
 *
 *     <nQueueID> is the bindery object ID of the queue
 *                You can get this from fn_gbndoid().
 *     <nJob>     is the job number.  This can be found in the
 *                job structure array returned from fn_crqjbfi().
 *                (Create queue job and file).  If you're using
 *                netto.ch, you can refer to this as QJ_JOB_NUMBER,
 *                e.g., aJobStruct[ QJ_JOB_NUMBER ]
 *     <nHandle>  is the file handle returned from fn_crQJbFi()
 *
 *  $RETURNS$
 *
 *     <lSuccess>, .t. if the call is successful.  If it isn't, check
 *     fn_error() for:
 *
 *          150    =  Server out of memory
 *          208    =  Queue error
 *          209    =  No queue
 *          211    =  No queue rights
 *          213    =  No queue job
 *          214    =  No job rights
 *          254    =  Server bindery locked
 *          255    =  Bindery failure
 *
 *  $DESCRIPTION$
 *
 *     When a station is finished with the queue job, it should
 *     issue this call to let QMS know the job is ready to be
 *     serviced by a queue server.  The station that created the
 *     job is the only station that can close and start it.
 *
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *     fn_gbndoid() fn_crqjbfi()
 *  $INCLUDE$
 *
 *  $END$
 */

#include "netto.ch"

function fn_stQJob( nQueueID, nJob, nHandle )
  local cReq, cRep, lRes := .f.

  if pcount()            == 3   .and. ;
     valtype( nQueueID ) == "N" .and. ;
     valtype( nJob )     == "N"

     if nHandle # -1
        if fclose( nHandle )

           cReq :=  I2BYTE( 105 )       + ;    // 69h
                    L2HILO( nQueueID )  + ;
                    W2HILO( nJob )
           cRep :=  ""

           lRes := ( _fnReq( 227, cReq, @cRep ) == ESUCCESS )

        else
           _fnSetErr( ferror() )
        endif
     endif
  else
     _fnSetErr( EBADPARM )
  endif

  return lRes
