; File......: FNROR.ASM
; Author....: Ted Means
; CIS ID....: 73067,3332
; Date......: $Date$
; Revision..: $Revision$
; Log file..: $Logfile$
; 
; This is an original work by Ted Means and is placed in the
; public domain.
;
; Modification history:
; ---------------------
;
; $Log$
;

; $DOC$
; $FUNCNAME$
;    FN_ROR()
; $CATEGORY$
;    Miscellaneous
; $ONELINER$
;    Rotate bits in an integer to the right
; $SYNTAX$
;
;    fn_ror( <nInt> | <cInt>, <nBits> ) -> nResult
;
; $ARGUMENTS$
;
;   <nInt> may either be a numeric integer, or a 16-bit character string
;   that is the binary representation of a numeric integer.  <nBits>
;   must be a numeric integer.
;
; $RETURNS$
;
;   <nResult>, a numeric
;
; $DESCRIPTION$
;
;   The value returned is obtained by rotating the bits in <nInt>
;   to the right.  <nBits> determines the number of bits to rotate.
;   If any parameters are invalid, the function will return zero.
;
; $EXAMPLES$
;
;   nX := 12
;   ? fn_ror( nX, 2 ) // 3
;
; $SEEALSO$
;
; $INCLUDE$
;
; $END$
;
;

IDEAL

PUBLIC   FN_ROR

EXTRN    __FNCBALL:FAR

SEGMENT  _FNNET  WORD      PUBLIC    "CODE"
         ASSUME    CS:_FNNET

PROC     FN_ROR       FAR

         MOV       AX,4ED3h
         MOV       DX,0CBFAh
         JMP       __FNCBALL

ENDP     FN_ROR
ENDS     _FNNET
END

