/*
 * File......: VOLINF.PRG
 * Author....: Glenn Scott
 * CIS ID....: 71620,1521
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by David Minter and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include 	"netto.ch"

/*  $DOC$
 *  $FUNCNAME$
 *      FN_VOLINF()
 *  $CATEGORY$
 *      File System
 *  $ONELINER$
 *      Get volume information 
 *  $SYNTAX$
 *
 *      fn_volinf( <nVol> ) -> aInfStruct
 *
 *  $ARGUMENTS$
 *
 *      <nVol> is the volume number
 *
 *  $RETURNS$
 *
 *      <aInfStruct>, an array as follows:           { more detail here }
 *
 *         System elapsed time
 *         Logical drive number
 *         Sectors per block
 *         Starting block
 *         Total blocks
 *         Available blocks
 *         Total Directory slots
 *         Available directory slots
 *         Actual max used directory slots
 *         Volume is hashed
 *         Volume is cached
 *         Volume is removable 
 *         Volume is mounted
 *         Volume name
 *
 *  $DESCRIPTION$
 *
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */


function fn_volinf( nVol )
	local cReq, cRep, aRes := {}, succ

  if pcount() == 1 .and. valtype( nVol ) == "N" 
     cReq := I2BYTE( 233 ) + I2BYTE( nVol )
     cRep := repl( chr(0), 42 )

     if _fnReq( 227, cReq, @cRep ) == ESUCCESS
        aRes := { HILO2L( subs( cRep,  1, 4 ) ),;       // System elapsed time
                  BYTE2I( subs( cRep,  6, 1 ) ),;       // Logical drive number
                  HILO2W( subs( cRep,  7, 2 ) ),;       // Sectors per block
                  HILO2W( subs( cRep,  9, 2 ) ),;       // Starting block
                  HILO2W( subs( cRep, 11, 2 ) ),;       // Total blocks
                  HILO2W( subs( cRep, 13, 2 ) ),;       // Available blocks
                  HILO2W( subs( cRep, 15, 2 ) ),;       // Total Directory slots
                  HILO2W( subs( cRep, 17, 2 ) ),;       // Available directory slots
                  HILO2W( subs( cRep, 19, 2 ) ),;       // Actual max used directory slots
                  subs( cRep,  21, 1 ) == I2BYTE( 1 ),; // Volume is hashed
		            subs( cRep,  22, 1 ) == I2BYTE( 1 ),; // Volume is cached
                  subs( cRep,  23, 1 ) == I2BYTE( 1 ),; // Volume is removable 
                  subs( cRep,  24, 1 ) == I2BYTE( 1 ),; // Volume is mounted
                  fn_noNull(  subs( cRep,  25 ));
                }
     endif
  else
     _fnSetErr( EBADPARM )
  endif

  return aRes 

