/*
 * File......: RIGHTS.PRG
 * Author....: Michael A. Cohen
 * CIS ID....: 72007,276
 * Date......: $Date: 28 May 1993 02:35:00$
 * Revision..: $Revision: 1.0$
 * Log file..: $Logfile$
 *
 * This is an original work by Michael Cohen and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

/*  $DOC$
 *  $FUNCNAME$
 *     FN_Rights()
 *  $CATEGORY$
 *     File System
 *  $ONELINER$
 *     Get effective rights to any directory (Netware, Local)
 *  $SYNTAX$
 *
 *     fn_Rights( <cDirectory> ) -> <cRights>
 *
 *  $ARGUMENTS$
 *
 *     <cDirectory> corresponds to a directory path, including drive letter
 *
 *  $RETURNS$
 *
 *     <cRights> returns a string of rights (RWOCDPSM), or "" for invalid drives.
 *
 *  $DESCRIPTION$
 *
 *     This call returns the current rights for a directory, local or Netware.
 *     It is a high level call that checks the drive type before calling the
 *     fn_getrights() function.  It assumes the user has full rights to the
 *     local drive.
 *     R - Read
 *     W - Write
 *     O - Open
 *     C - Create
 *     D - Delete
 *     P - Parental
 *     S - Scan
 *     M - Modify
 *
 *  $EXAMPLES$
 *       function main( cDirectory )
 *
 *          local cRights
 *
 *          cRights := fn_Rights( cDirectory )
 *
 *       return(NIL)
 *
 *  $SEEALSO$
 *    FN_GetRights()
 *
 *  $INCLUDE$
 *
 *  $END$
 */
#ifdef FT_TEST
   function main( cDirectory )
      ? fn_rights( cDirectory )
   return NIL
#endif

FUNCTION fn_rights(cDirectory)
// Return the Network rights for a drive (RWOCDPSM)
LOCAL cRights,nDrive,nType
cDirectory := iif(empty(cDirectory),ft_default()+":"+curdir(),cDirectory)
nDrive := asc(upper(substr(cDirectory,1,1)))-asc("A")+1
nType := fn_devtype(nDrive)
if nType==2                             // Network drive
   cRights := fn_getrights(cDirectory)  // Returns a string of "RWOCDPSM"
elseif nType==1 .or. nType==3           // For Local or Subst drives.
   cRights := "RWOCDPSM"
else
   cRights := ""                        // Invalid drive
endif
Return cRights
