/*
 * File......: DELETDIR.PRG
 * Author....: Ted Means
 * CIS ID....: 73067,3332
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Ted Means and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "netto.CH"

/*  $DOC$
 *  $FUNCNAME$
 *     FN_RMDIR()
 *  $CATEGORY$
 *     File System
 *  $ONELINER$
 *     Delete directory
 *  $SYNTAX$
 *
 *     fn_RmDir( <nHandle> [, <cPath>]  ) --> <nStatus>
 *
 *  $ARGUMENTS$
 *
 *    <nHandle> is a handle to a directory path, usually obtained with
 *              fn_alTemDH().
 *
 *    <cPath> is the desired pathspec.  If the pathspec is fully defined
 *            by the handle, then pass an empty string or NIL.
 *
 *  $RETURNS$
 *
 *    <nStatus> will be zero if the directory was deleted.  If an error
 *              occurred then <nStatus> will contain a NetWare error code;
 *              see netto.CH for possible values.
 *
 *  $DESCRIPTION$
 *
 *    This call deletes a directory on a file server, given the directory
 *    path.  Delete privileges must be in effect and the directory must
 *    be empty and not in use.
 *
 *  $EXAMPLES$
 *    // Delete a directory from the SYS volume
 *
 *    fn_RmDir(  0, "SYS:\THISDIR" )
 *
 *    // Delete a directory from the VOL1 volume using a handle
 *
 *    aDHInfo := fn_alTemDH( 0, "H", "VOL1:\" )
 * 
 *    fn_RmDir( aDHInfo[ 1 ] )
 *
 *  $SEEALSO$
 *    fn_MkDir() fn_GetCD() fn_RenDir()
 *  $INCLUDE$
 *    netto.CH (only needed if you want to make use of the #defines for
 *              the error codes).
 *  $END$
 */

function fn_RmDir( nHandle, cPath )
  local cReply

  default cPath to ""

  cReply := i2bin( 0 )

  return _fnReq( 226, chr( 11 )           + ;   // Subservice 0Bh
                       chr( nHandle )      + ;   // Convert handle to char
                       chr( 0 )            + ;   // This byte is unused
                       chr( len( cPath ) ) + ;   // Length of pathspec
                       cPath,                ;   // Pathspec string
                       @cReply )


