/*
 * File......: ALLOCHAN.PRG
 * Author....: Glenn Scott
 * CIS ID....: 71620,1521
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Glenn Scott and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "netto.ch"

#define    ALLOC_PERM     18       /* 12h DON'T CHANGE THIS! */
#define    ALLOC_TEMP     19       /* 13h DON'T CHANGE THIS! */

/*  $DOC$
 *  $FUNCNAME$
 *     fn_alPerDH()
 *  $CATEGORY$
 *     File System
 *  $ONELINER$
 *     Allocate permanent directory handle
 *  $SYNTAX$
 *
 *     fn_alPerDH( <nHandle>, <cDriveLtr>, <cDirPath> ) 
 *                     -> { nHandle, nEffRights }
 *
 *  $ARGUMENTS$
 *
 *  $RETURNS$
 *
 *  $DESCRIPTION$
 *
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

function fn_alPerDH( nHandle, cDrive, cDirPath )
  return _fnAlloch( ALLOC_PERM, nHandle, cDrive, cDirPath )


/*  $DOC$
 *  $FUNCNAME$
 *     fn_alTemDH()
 *  $CATEGORY$
 *     File System
 *  $ONELINER$
 *     Allocate temporary directory handle
 *  $SYNTAX$
 *
 *     fn_alTemDH( <nHandle>, <cDriveLtr>, <cDirPath> ) 
 *                     -> { nHandle, nEffRights }
 *
 *  $ARGUMENTS$
 *
 *  $RETURNS$
 *
 *  $DESCRIPTION$
 *
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */


function fn_alTemDH( nHandle, cDrive, cDirPath )
  return _fnAlloch( ALLOC_TEMP, nHandle, cDrive, cDirPath )


static function _fnAlloch( nOp, nHandle, cDrive, cDirPath )
  local cReq, cRep, aRes := {}

  if pcount() == 4 .and. ;
        valtype( nHandle )  == "N" .and. ;
        valtype( cDrive  )  == "C" .and. ;
        len( cDrive )       == 1   .and. ;
        valtype( cDirPath ) == "C"
     
     cReq := I2BYTE( nOp )             + ;
             I2BYTE( nHandle )         + ;
             upper( cDrive )           + ;
             I2BYTE( len( cDirPath ) ) + ;
             cDirPath

     cRep := chr(0) + chr(0) 
     if _fnReq( 226, cReq, @cRep ) == ESUCCESS 
        aRes := { BYTE2I( subs( cRep, 1, 1 ) ),;     // New directory handle
                  BYTE2I( subs( cRep, 2, 1 ) );      // Effective rights mask
                }
     endif
  else
     _fnSetErr( EBADPARM )
  endif

  return aRes


/*  $DOC$
 *  $FUNCNAME$
 *     fn_dealDH()
 *  $CATEGORY$
 *     File System
 *  $ONELINER$
 *     Deallocate directory handle
 *  $SYNTAX$
 *
 *     fn_deAlDH( nDirHandle ) -> lResult
 *
 *  $ARGUMENTS$
 *
 *  $RETURNS$
 *
 *  $DESCRIPTION$
 *
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

function fn_deAlDH( nDirHandle )
  local cReq, cRep, lRes := .f.

  if pcount() == 1 .and. valtype( nDirHandle ) == "N"
     cReq := I2BYTE( 20 ) + I2BYTE( nDirHandle )
     cRep := ""

     lRes := ( _fnReq( 226, cReq, @cRep ) == ESUCCESS )
  else
     _fnSetErr( EBADPARM )
  endif

  return lRes
