/*
 * File......: CONNUM.PRG
 * Author....: Steve Larsen
 * CIS ID....: 76370,1532
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Steve Larsen and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "ftint86.ch"
#include "netto.ch"

#define E3h	227

/*  $DOC$
 *  $FUNCNAME$
 *      fn_connNum()
 *  $CATEGORY$
 *      Connection/Workstation
 *  $ONELINER$
 *      GetConnectionNumber
 *  $SYNTAX$
 *
 *      fn_connNum() -> nConnectionNo
 *
 *  $ARGUMENTS$
 *
 *      None
 *
 *  $RETURNS$
 *
 *      The current workstation's Logical Connection Number.
 *
 *  $DESCRIPTION$
 *
 *      This function returns the connection number of the user logged in
 *      at the station making the call.  If the user is not logged in, 0 is
 *      returned.
 *
 *  $EXAMPLES$
 *
 *      nConnNum := fn_connNum()	// get connection number
 *
 *  $SEEALSO$
 *      fn_connInf() fn_connID() fn_objCNum()
 *  $INCLUDE$
 *
 *  $END$
 */

FUNCTION fn_connNum()
	LOCAL aRegs[ INT86_MAX_REGS ], nRetVal := 0

	aRegs[ AX ] := ft_HEX2DEC( "DC00" )   // Netware Service DCh

	IF !ft_int86( INT21, aRegs )          // fetch Conn No.
		_fnSetErr( EINT86 )
 	ELSE
		nRetVal := UNSIGNED( LowByte( aRegs[ AX ] ) )
	ENDIF

RETURN ( nRetVal )


/*  $DOC$
 *  $FUNCNAME$
 *      fn_objCNum()
 *  $CATEGORY$
 *      Connection/Workstation
 *  $ONELINER$
 *      GetObjectConnectionNumbers
 *  $SYNTAX$
 *
 *      fn_objCNum( <cObjectName> [, <nObjectType> ] ) -> aConnectionNumbers
 *
 *  $ARGUMENTS$
 *
 *      <cObjectName> is the name of the Object that you are interested in.
 *      It can be from 1 to 47 characters in length.
 *
 *      <nObjectType> is the Netware object type.  For a list of object types
 *      refer to the "Information" section in this Norton Guide, or NETTO.CH.
 *      If omitted, <nObjectType> defaults to OT_USER.
 *
 *  $RETURNS$
 *
 *      An array containing a list of each logical connection number for the
 *      requested object.  If the object is not logged into the default
 *      file server, an empty array is returned.
 *
 *  $DESCRIPTION$
 *
 *      Use this function to learn where a particular object is logged into
 *      the default file server.  This can be useful when sending messages
 *      to other users.
 *
 *  $EXAMPLES$
 *
 *      /* user MARY is logged in at 3 workstations on the default server */
 *
 *      aLogins := fn_objCNum( "Mary", OT_USER )
 *
 *      ? LEN( aLogins )                         // 3
 *
 *  $SEEALSO$
 *      fn_connNum() fn_scnBndO()
 *  $INCLUDE$
 *
 *  $END$
 */

FUNCTION fn_objCNum( cObjectName, nObjectType )
	LOCAL cReqBuffer, cRepBuffer := REPLICATE( I2BYTE( 0 ), 101 )
	LOCAL aReply := {}, i
	DEFAULT cObjectName TO "", nObjectType TO OT_USER

	cReqBuffer := I2BYTE( FT_HEX2DEC( "15" ) )	+;
					  W2HILO( nObjectType )       	+;
					  fn_nameL( UPPER( cObjectName ) )

	_fnReq( E3h, cReqBuffer, @cRepBuffer )

	/* build return array */

	ASIZE( aReply, BYTE2I( SUBSTR( cRepBuffer, 1, 1 ) ) )

	FOR i := 1 TO LEN( aReply )
		aReply[ i ] := BYTE2I( SUBSTR( cRepBuffer, i + 1, 1 ) )
	NEXT

RETURN( aReply )
