/*
 * File......: GETOBJID.PRG
 * Author....: Kevin Maher/Steve Tyrakowski
 * CIS ID....: 73766,1224
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Kevin Maher and Steve Tyrakowski
 * and is placed in the public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     FN_gBndOID()
 *  $CATEGORY$
 *     Bindery
 *  $ONELINER$
 *     Get Bindery Object Id
 *  $SYNTAX$
 *
 *     FN_gBndOID(<cObjectName>, <nObjectType>) => nObjectId
 *
 *  $ARGUMENTS$
 *
 *     <cObjectName> is the name of the Object that you are trying
 *		     to read the property info for.  Max Length = 47
 *
 *     <nObjectType> is the Bindery Object Type.  Manifest constants
 *		     describing the defined types are included in the
 *		     NETTO.CH header file.
 *
 *  $RETURNS$
 *
 *     Returns the bindery objectid of the bindery object name passed.
 *     The ID is returned as a Clipper Numeric value.
 *
 *  $DESCRIPTION$
 *
 *     This function returns a bindery object's unique id number.
 *
 *  $SEEALSO$
 *     fn_BndONam()
 *  $EXAMPLES$
 *
 *	 cObject := "EVERYONE"
 *	 nType	 := OT_USER_GROUP
 *
 *	 // this will return the object id of the object EVERYONE
 *	 nId := FN_gBndOid(cObject, nType)
 *	 QOut(nId)
 *
 *  $END$
 */

#include "netto.ch"

#xcommand DEFAULT <v1> TO <x1> [, <vN> TO <xN> ];
      => IIF((<v1>)=NIL,<v1>:=<x1>,NIL) [; IF((<vN>)=NIL,<vN>:=<xN>,NIL)]

#define NW_LOG 227

#ifdef FT_TEST
  FUNCTION MAIN(cObjectName, nObjectType)
    LOCAL   nId
    DEFAULT cObjectName TO "EVERYONE"
    DEFAULT nObjectType TO OT_USER_GROUP

    IF ValType(nObjectType) == "C"
      nObjectType := Val(nObjectType)
    ENDIF

    nId := FN_gBndOid( cObjectName, nObjectType)

    QOut(nId,cObjectName,nObjectType)

  RETURN ( nil )
#endif


FUNCTION FN_gBndOID(cName, nType)
  LOCAL cReceive := Space(54)		 // Set up Receive Buffer
  LOCAL nRetVal  := 0
  LOCAL cSend	 := I2BYTE(53) ;	 // 35h  API Function Request Code
		  + W2HILO(nType) ;	 // Object Type
		  + FN_NameL(alltrim(cName), 48)  // Length Encoded Object Name

   IF _fnReq(NW_LOG, cSend, @cReceive) == ESUCCESS
     nRetVal := HILO2L(Left(cReceive, 4))	  // Return ID as a number
   ENDIF

RETURN nRetVal
