/*********************************************************************

	MainMenu.PRG - Main menu for the demo program.

	Author: Dave Rooney
	Date  : Feb. 22, 1993

*********************************************************************/

#include "Demo.ch"


FUNCTION MainMenu

LOCAL nChoice,    ; // User selection from menu
		aMessages,  ; // Array storing message text
		PromptList, ; // Array for the menu prompts
		lExit         // Return flag

nChoice    := 0
PromptList := {}
lExit      := .F.

aMessages := { ;
	"Browse sample source code used for this demo program", ;
	"Browse the Clipper header file used for this demo program", ;
	"Browse the RMake script file used for this demo program", ;
	"Browse the linker script files used for this demo program", ;
	"Sample of the different features of the GET system", ;
	"Sample of using the event system to perform background processing", ;
	"Sample of using the GET and Event systems together", ;
	"Example of a simple STDBrowse", ;
	"Example of a full-featured STDBrowse with a menu" }

@ 0,2 PROMPT "~Browse" ;
	MESSAGE "Sample source code illustrating usage of the CUA-Clip Library" ;
	PULLDOWN ;
	{  { " ~Source code examples  ", aMessages[1], {|| BrowseFile( "*.PRG" ) } }, ;
		{ " ~Header file example   ", aMessages[2], {|| BrowseFile( "*.CH" ) } }, ;
		{ " ~RMake script example  ", aMessages[3], {|| BrowseFile( "*.RMK" ) } }, ;
		{ " ~Linker script examples", aMessages[4], {|| BrowseFile( "*.LNK" ) } }, ;
		{ " ~All files             ", "", {|| BrowseFile( "*.*" ) } } }

@ 0,COL() + 2 PROMPT "~Examples" ;
	MESSAGE "Examples of the various features of the CUA-Clip Library" ;
	PULLDOWN ;
	{  { "GETs               ", aMessages[5], {|| GET_Examples(), .T. }, {|| .T. } }, ;
		{ "Event System       ", aMessages[6], {|| Event_Examples(), .T. }, {|| .T. } }, ;
		{ "GET & Event Systems", aMessages[7], {|| Combo_Examples(), .T. }, {|| .T. } }, ;
		{ "Simple STDBrowse   ", aMessages[8], {|| Browse_Examples(), .T. }, {|| .T. } }, ;
		{ "Cool STDBrowse     ", aMessages[9], {|| TheWholeThing(), .T. }, {|| .T. } } }

@ 0,COL() + 2 PROMPT "~Quit!" ;
	ACTION !( lExit := .T. ) ;
	MESSAGE "Exit and return to DOS"

DO WHILE !lExit
	MENU TO nChoice SAVE USING LastMenu()
ENDDO

RETURN lExit
//
// EOP: MainMenu
//


