/*
    Function:  CapFirst 

    Author:    DAVID -( FLASH )- GORDON

    Date:      4 MAY 93

    Purpose:   Cleans Up Menus, Error Messages and Warnings, or
               Any Other Text You Need Displayed CapFirst.

    Copyright (c) 1993 - FLASHPOINT - ALL RIGHTS RESERVED 

NOTE:

 -  This Function Came Into Existence For Me When A Large (47K Line) Program
    Had All of Its Source Code Reduced To Lower Case And All Comments Removed.

 -  All Network Messages and Text Displayed In Windows Was In Need of Clean Up
    And It Was Eaisier To Add The Function Call Than To Correct The Text.

 -  Some Examples of Use Are Below The Source Code Listing.

 -  This is all Cliper v5.01 Code
*/

STATIC FUNCTION CAPFIRST( cOldString )

    LOCAL cNewChar := cNewString := "", lCapNext := .t.

    IIF( PCOUNT() # 1 .or. VALTYPE( cOldString ) # "C", cOldString := "", )

*   cOldString := LOWER( cOldString )

    FOR nElement := 1 to LEN( cOldString )

        cNewChar := SUBSTR( cOldString, nElement, 1 )

        IF cNewChar == " " .or. cNewChar == "-" .or. cNewChar == "."
            cNewString := cNewString + cNewChar
            lCapNext := .t.
        ELSEIF lCapNext
            cNewString := cNewString + UPPER( cNewChar )
            lCapNext := .f.
        ELSE
            cNewString := cNewString + cNewChar
        ENDIF

    NEXT nElement

RETURN cNewString


/*

Examples and Other Comments

    The first character of the string is raised
    Any character in the string following a SPACE, PERIOD, or HYPHEN is raised
    Any text passed raised will remain so unless you activate the LOWER() line

    1.  cText := "this is a test of the capfirst function"
        @ 15,20 SAY CAPFIRST( cText )                                         
                                                                         
        or                                                                    
                                                                         
        @ 15,20 SAY CAPFIRST( "this is a test of the capfirst function" )     
                                                                         
        Returns                                                               
                                                                         
        This Is A Test Of The Capfirst Function                               


    2.  cText := "capt. john hill MD"

        Returns

        Capt. John Hill MD

*/

