/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990, 1991, 1992 BecknerVision Inc - All Rights Reserved

    Written by John Wm Beckner        THIS NOTICE MUST NOT BE REMOVED
    BecknerVision Inc
    PO Box 11945                      DISTRIBUTE ONLY WITH SHAREWARE
    Winston-Salem NC 27116            VERSION OF THIS PRODUCT.
    Fax: 919/760-1003

*/

#include "beckner.inc"

FUNCTION Standard()
   LOCAL cProgram := space(8), cFunction := 'Main'+space(11), cCoprYear := '1991'
   LOCAL cCoprName := 'BecknerVision Inc', nSource, nMax, lMain := .y., aPrompt
   LOCAL cAuthor := 'John Wm Beckner            ', cTitle := space(30), aGet
   LOCAL cDBF, aFldName, aType, aWidth, aDec, aPicture, aValid, aWhen, cScrInfo

   SET KEY -8 to pCtrlW
   CLS
   @ 1, 0 say "Create STANDARD program with BECKNER.LIB"
   @ 2, 0 say "Copyright (c)1991 BecknerVision Inc - All Rights Reserved"
   @ 4, 0 say 'Program title ................' get cTitle
   @ row()+1, 0 say 'Program name .................' get cProgram picture '@!'
   @ row()+1, 0 say 'Main function name ...........' get cFunction
   @ row()+1, 0 say 'Copyright year ...............' get cCoprYear pict '9999'
   @ row()+1, 0 say 'Copyright name ...............' get cCoprName
   @ row()+1, 0 say "Author's name ................" get cAuthor
   READ
   cTitle    := trim(cTitle)
   cProgram  := trim(cProgram)
   cFunction := trim(cFunction)
   cCoprName := trim(cCoprName)
   cAuthor   := trim(cAuthor)
   nSource   := fCreate(cProgram+".PRG")
   fWrite(nSource, "/*"+CRLF+CRLF)
   fWrite(nSource, "  Program title: "+cTitle+CRLF)
   fWrite(nSource, "    Source name: "+cProgram+CRLF)
   fWrite(nSource, "   Date created: "+dtoc(date())+CRLF)
   fWrite(nSource, "         Author: "+cAuthor+CRLF)
   fWrite(nSource, "         Notice: Copyright (c)"+cCoprYear+" "+cCoprName)
   fWrite(nSource, " - All Rights Reserved"+CRLF+CRLF)
   fWrite(nSource, "   Written with the assistance of the ")
   fWrite(nSource, "Standard Program Creator"+CRLF)
   fWrite(nSource, "   Copyright (c)1991 BecknerVision Inc - All Rights")
   fWrite(nSource, " Reserved"+CRLF+CRLF)
   fWrite(nSource, "*/"+CRLF+CRLF)
   fWrite(nSource, "#define ENDWHILE END"+CRLF)
   fWrite(nSource, "#define LOOPING .y."+CRLF+CRLF)
   fWrite(nSource, "FUNCTION "+cFunction+"()"+CRLF)
   fWrite(nSource, "LOCAL cTemp, aOptions := {}, cScreen"+CRLF)
   fWrite(nSource, "PRIVATE aScrInfo := {}"+CRLF)
   fWrite(nSource, "SET EXCLUSIVE off"+CRLF)
   fWrite(nSource, "SET DELETED on"+CRLF)
   fWrite(nSource, "SET SCOREBOARD off"+CRLF)
   fWrite(nSource, "SET KEY -1 to pHelp"+CRLF)
   fWrite(nSource, "SET KEY -8 to pCtrlW"+CRLF)
   fWrite(nSource, "CLS"+CRLF)
   fWrite(nSource, "vBackground(chr(177))"+CRLF)
   fWrite(nSource, "vTitle({'"+cTitle+"',;"+CRLF)
   fWrite(nSource, "         'Copyright (c)"+cCoprYear+" "+cCoprName)
   fWrite(nSource, " - All Rights Reserved',;"+CRLF)
   fWrite(nSource, "         'Written by "+cAuthor+"',;"+CRLF)
   fWrite(nSource, "         'Version 1.0'})"+CRLF)
   fWrite(nSource, "vMessageOn('Opening/Creating Data Files')"+CRLF)
   WHILE LOOPING
      aFldName := {}
      aType    := {}
      aWidth   := {}
      aDec     := {}
      aPrompt  := {}
      aGet     := {}
      aPicture := {}
      aValid   := {}
      aWhen    := {}
      @ 4,0 clear to 24,79
      cDBF     := space(8)
      @ 4,0 say 'Database filename (press <enter> when done):' get cDBF;
      picture '@!'
      READ
      IF empty(cDBF)
         EXIT
      ENDIF
      cScrInfo := ""
      cDBF     := trim(cDBF)
      @ 5, 0 say 'Field Name  Type Width Dec Prompt               Get? Picture'
      @ 5, col()+1 say '    Valid     When'
      SetPos(5, 0)
      WHILE LOOPING
         aAdd(aFldName, space(10))
         aAdd(aType, "C")
         aAdd(aWidth, 10)
         aAdd(aDec, 0)
         aAdd(aPrompt, space(30))
         aAdd(aGet, .y.)
         aAdd(aPicture, space(50))
         aAdd(aValid, space(200))
         aAdd(aWhen, space(200))
         @ row()+1, 0 get aFldName[(nMax := len(aFldName))]
         @ row(), 12 get aType[nMax] picture '@!A';
         valid aType[nMax]$'CLNDM' when !empty(aFldName[nMax])
         @ row(), 17 get aWidth[nMax] picture '99999';
         when !aType[nMax]$'DLM'.and.!empty(aFldName[nMax])
         @ row(), 23 get aDec[nMax] picture '999';
         when aType[nMax]='N'.and.!empty(aFldName[nMax])
         @ row(), 27 get aPrompt[nMax] picture '@S20' when !empty(aFldName[nMax])
         @ row(), 48 get aGet[nMax] picture 'Y' when !empty(aFldName[nMax])
         @ row(), 52 get aPicture[nMax] picture '@S9' when !empty(aFldName[nMax])
         @ row(), 62 get aValid[nMax] picture '@S9' when !empty(aFldName[nMax])
         @ row(), 72 get aWhen[nMax] picture '@S9' when !empty(aFldName[nMax])
         vCursSave()
         READ
         vCursRest()
         vCursSave()
         @ row()+1, 0 say aFldName[nMax]
         @ row(), 12 say aType[nMax]
         @ row(), 17 say aWidth[nMax] picture '99999'
         @ row(), 23 say aDec[nMax] picture '999'
         @ row(), 27 say left(aPrompt[nMax], 20)
         @ row(), 47 say iif(aGet[nMax], 'Yes', ' No')
         @ row(), 52 say left(aPicture[nMax], 9)
         @ row(), 62 say left(aValid[nMax], 9)
         @ row(), 72 say left(aWhen[nMax], 9)
         vCursRest()
         IF empty(aFldName[nMax])
            EXIT
         ENDIF
         IF row()=maxrow()
            vScroll(6, 0, maxrow(), 79)
            SetPos(maxrow()-1, 0)
         ENDIF
         cScrInfo += trim(aPrompt[nMax])+'       //'+iif(aGet[nMax], 'G/', 'S/')
         cScrInfo += trim(aPicture[nMax])+'      //'+trim(aValid[nMax])+'//'
         cScrInfo += trim(aWhen[nMax])+'         ///'
      ENDWHILE
      fWrite(nSource, "IF !file('"+cDBF+".DBF')"+CRLF)
      fWrite(nSource, "   cTemp := '"+cDBF+"/'"+CRLF)
      nMax--
      nMax--
      FOR nCtr := 1 to nMax
         fWrite(nSource, "   cTemp += '"+trim(aFldName[nCtr])+"/"+aType[nCtr]+"/")
         fWrite(nSource, iif(aType[nCtr]$'NC', ltrim(str(aWidth[nCtr]))+'/', NIL))
         iif(aType[nCtr]='N', fWrite(nSource, ltrim(str(aDec[nCtr]))+'/'), NIL)
         fWrite(nSource, "'"+CRLF)
      NEXT
      nMax++
      fWrite(nSource, "   cTemp += '"+trim(aFldName[nCtr])+"/"+aType[nMax]+"/")
      fWrite(nSource, iif(aType[nMax]='M', "10", iif(aType[nMax]='D', "8",;
      iif(aType[nMax]='L', "1", ltrim(str(aWidth[nCtr]))+''))))
      iif(aType[nMax]='N', fWrite(nSource, '/'+ltrim(str(aDec[nCtr]))), NIL)
      fWrite(nSource, "'"+CRLF)
      fWrite(nSource, "   fCreateDBF(cTemp)"+CRLF)
      fWrite(nSource, "ENDIF"+CRLF)
      fWrite(nSource, "aAdd(aScrInfo, '"+iif(lMain, "Main", cProgram)+"/")
      fWrite(nSource, left(cScrInfo, len(cScrInfo)-3)+"')"+CRLF)
      fWrite(nSource, "fShare('"+cDBF)
      IF lMain
         lMain := .n.
         fWrite(nSource, "', 'Main')"+CRLF)
      ELSE
         fWrite(nSource, "')"+CRLF)
      ENDIF
      cTemp := ""
      aFldName := {}
      aType := {}
      @ 5, 0 clear to 24, 79
      @ 5, 10 say 'Index Filename      Expression'
      SetPos(5, 0)
      WHILE LOOPING
         aAdd(aFldName, space(8))
         aAdd(aType, space(254))
         vCursSave()
         @ row()+1, 10 get aFldName[(nMax := len(aFldName))] picture '@!'
         @ row(), 30 get aType[nMax] picture '@S45'
         READ
         aType[nMax] := trim(aType[nMax])
         vCursRest()
         IF empty(aFldName[nMax])
            EXIT
         ENDIF
         aFldName[nMax] := trim(aFldName[nMax])
         IF row()=maxrow()
            vScroll(6, 0, maxrow(), 79)
            SetPos(maxrow()-1, 0)
         ENDIF
      ENDWHILE
      nMax--
      FOR nCtr := 1 to nMax
         cTemp += aFldName[nCtr]+", "
         fWrite(nSource, "IF !file('"+aFldName[nCtr]+".NTX')"+CRLF)
         fWrite(nSource, "   INDEX on "+aType[nCtr]+" to "+aFldName[nCtr]+CRLF)
         fWrite(nSource, "ENDIF"+CRLF)
      NEXT
      iif(nMax>0, fWrite(nSource, "SET INDEX to "+left(cTemp, len(cTemp)-2);
      +CRLF), NIL)
   ENDWHILE
   fWrite(nSource, "vMessageOff()"+CRLF)
   fWrite(nSource, "CLS"+CRLF)
   fWrite(nSource, "SetColor('n+/w')"+CRLF)
   fWrite(nSource, "vBackground(chr(177))"+CRLF)
   fWrite(nSource, "SetColor('bg+/b,b/w')"+CRLF)
   fWrite(nSource, "aOptions := {'Add', 'Edit', 'Get', 'Next', 'Prior', 'Browse'")
   fWrite(nSource, ", 'Reports',;"+CRLF)
   fWrite(nSource, "      'Maintenance', 'Quit'}"+CRLF)
   fWrite(nSource, "WHILE LOOPING"+CRLF)
   fWrite(nSource, "   SELECT Main"+CRLF)
   fWrite(nSource, "   cScreen := vSave()"+CRLF)
   fWrite(nSource, "   pOnDo(vMenu('T', aOptions), {'stAdd(aScrInfo)', ")
   fWrite(nSource, "'stEdit()', 'rFullGet()',;"+CRLF)
   fWrite(nSource, "      'rNextRec()', 'rPriorRec()', 'stBrowse()', ")
   fWrite(nSource, "'stReports()',;"+CRLF)
   fWrite(nSource, "      'stMaint()', 'pQuit()'})"+CRLF)
   fWrite(nSource, "   vRestore(cScreen)"+CRLF)
   fWrite(nSource, "ENDWHILE"+CRLF+CRLF)
   fWrite(nSource, "FUNCTION stAdd(aScrInfo)"+CRLF)
   fWrite(nSource, "LOCAL aField, aPrompt := {}, aSayGet := {}, aPicture := {}, ")
   fWrite(nSource, "aValid := {}, aWhen := {}"+CRLF)
   fWrite(nSource, "LOCAL nElement, cTemp, nCtr := 0"+CRLF)
   fWrite(nSource, "IF (nElement := aScan(aScrInfo, alias()))=0"+CRLF)
   fWrite(nSource, "   RETURN NIL"+CRLF)
   fWrite(nSource, "ENDIF"+CRLF)
   fWrite(nSource, "cTemp := aScrInfo[nElement]"+CRLF)
   fWrite(nSource, "sParse(@cTemp)"+CRLF)
   fWrite(nSource, "WHILE !empty(cTemp)"+CRLF)
   fWrite(nSource, "   aAdd(aField, FieldName(++nCtr))"+CRLF)
   fWrite(nSource, "   aAdd(aPrompt, sParse(@cTemp, ' //'))"+CRLF)
   fWrite(nSource, "   aAdd(aSayGet, sParse(@cTemp))"+CRLF)
   fWrite(nSource, "   aAdd(aPicture, sParse(@cTemp, ' //'))"+CRLF)
   fWrite(nSource, "   aAdd(aValid, sParse(@cTemp, ' //'))"+CRLF)
   fWrite(nSource, "   aAdd(aWhen, sParse(@cTemp, ' ///'))"+CRLF)
   fWrite(nSource, "ENDWHILE"+CRLF)
   fWrite(nSource, "fFullAdd(aField, aPrompt, aSayGet, aPicture, aValid, aWhen)")
   fWrite(nSource, CRLF)
   fWrite(nSource, "RETURN NIL"+CRLF+CRLF)
   fWrite(nSource, "FUNCTION stEdit()"+CRLF)
   fWrite(nSource, "fLockRec()"+CRLF)
   fWrite(nSource, "@ maxrow(), 0"+CRLF)
   fWrite(nSource, "@ maxrow(), 0 say 'Record #'+ltrim(transform(recno(),")
   fWrite(nSource, " '99,999'))"+CRLF)
   fWrite(nSource, "fDataEdit()"+CRLF)
   fWrite(nSource, "UNLOCK"+CRLF)
   fWrite(nSource, "RETURN NIL"+CRLF+CRLF)
   fWrite(nSource, "FUNCTION stBrowse()"+CRLF)
   fWrite(nSource, "fLockFile()"+CRLF)
   fWrite(nSource, "Browse(1, 0, maxrow(), maxcol())"+CRLF)
   fWrite(nSource, "UNLOCK"+CRLF)
   fWrite(nSource, "RETURN NIL"+CRLF+CRLF)
   fWrite(nSource, "FUNCTION stReports()"+CRLF)
   fWrite(nSource, "LOCAL cScreen, aRC, nOption := 1"+CRLF)
   fWrite(nSource, "cScreen := vSave()"+CRLF)
   fWrite(nSource, "set(36, maxrow())"+CRLF)
   fWrite(nSource, "set(37, .y.)"+CRLF)
   fWrite(nSource, "WHILE LOOPING"+CRLF)
   fWrite(nSource, "   aRC := vWindow(3, 20, .y., 'REPORTS')"+CRLF)
   fWrite(nSource, "   @ aRC[1], aRC[2] prompt 'Report Generator    ' ")
   fWrite(nSource, "message 'Invokes the Beckner Report Generator'"+CRLF)
   fWrite(nSource, "   @ row()+1, aRC[2] prompt 'Forms Generator     ' ")
   fWrite(nSource, "message 'Invokes the Beckner Forms Generator'"+CRLF)
   fWrite(nSource, "   @ row()+1, aRC[2] prompt 'Word processor     ' ")
   fWrite(nSource, "message 'Invokes the Beckner Word Processor'"+CRLF)
   fWrite(nSource, "   MENU to nOption"+CRLF)
   fWrite(nSource, "   IF nOption=0"+CRLF)
   fWrite(nSource, "      RETURN NIL"+CRLF)
   fWrite(nSource, "   ENDIF"+CRLF)
   fWrite(nSource, "   pOnDo(nOption, {'BecknerRL()', 'BecknerFG()', ")
   fWrite(nSource, "'BecknerWP()'})"+CRLF)
   fWrite(nSource, "   vRestore(cScreen)"+CRLF)
   fWrite(nSource, "ENDWHILE"+CRLF+CRLF)
   fWrite(nSource, "FUNCTION stMaint()"+CRLF+CRLF)
   fWrite(nSource, "*EOP"+CRLF)
   fClose(nSource)
   nSource := fCreate("STC.BAT")
   fWrite(nSource, "echo off"+CRLF)
   fWrite(nSource, "cls"+CRLF)
   fWrite(nSource, "clipper "+cProgram+" -n -m -w"+CRLF)
   fWrite(nSource, "if errorlevel 1 goto errs"+CRLF)
   fWrite(nSource, "rtlink fi "+cProgram+", beckner2, beckner3, beckner4 ")
   fWrite(nSource, "lib beckner pll base50"+CRLF)
   fWrite(nSource, "cls"+CRLF)
   fWrite(nSource, "echo To abort press {ctrl-C} or To run program"+CRLF)
   fWrite(nSource, "pause"+CRLF)
   fWrite(nSource, cProgram)
   fClose(nSource)
   CLS
   ?? "Created source code file "+cProgram+".PRG"
   ? "To compile/link/run, enter STC"
   ?
ENDFUNCTION
