/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990, 1991, 1992 BecknerVision Inc - All Rights Reserved

    Written by John Wm Beckner        THIS NOTICE MUST NOT BE REMOVED
    BecknerVision Inc
    PO Box 11945                      DISTRIBUTE ONLY WITH SHAREWARE
    Winston-Salem NC 27116            VERSION OF THIS PRODUCT.
    Fax: 919/760-1003

*/

#include "beckner.inc"

FUNCTION ExampleD()
   LOCAL dDate, nTemp := 100, cTemp := "Beckner Library"
   PRIVATE dTemp

   dDate := date()
   CLS
   @ 1,0 say "Beckner Date Functions"
   @ 3,0 say "Enter a date:" get dDate
   READ
   dTemp := dDate
   CLS
   ? "The beginning of the month is", dBegMonth(dDate)
   ? "The end of the month is", dEndMonth(dDate)
   ? "The beginning of the quarter is", dBegQuarter(dDate)
   ? "The end of the quarter is", dEndQuarter(dDate)
   ? "This is the", dDay2Str(day(dDate)), "of the month"
   ? "There are", ltrim(str(dDaysInMonth(dDate))), "in the month"
   ?
   ? "Use dPicture will cause your date to be displayed as",;
   transform(dDate, dPicture(dDate))
   ? "but an empty date would be displayed as",;
   transform(dEmpty(), dPicture(dDate))
   ?
   ? "1 year later is", dSame(dDate, 12)
   ? "1 year ago   is", dSame(dDate, -12)
   ?
   ? "The date you entered is", dWord(dDate)
   ? "Day of the year:", dDayOfYear(dDate)
   WAIT
   CLS
   @ 1,0 say;
   "The next fields let you press <+> to advance the date or <-> to decrease it."
   @ 2,0 say;
   "Note that using these keys in a field other than a date field is ignored."
   @ 4,0 say "Numeric ............" get nTemp
   @ 5,0 say "Date ..............." get dTemp
   @ 6,0 say "Character .........." get cTemp
   SET KEY 43 to dInc
   SET KEY 45 to dDec
   READ
   SET KEY 43 to
   SET KEY 45 to
   CLS
   ?
   ? "Days gone in the month:", dDaysGoneM(dDate)
   ? "Days gone in the quarter:", dDaysGoneQ(dDate)
   ? "Is this a leap year?", if(dLeapYear(), "Yes", "No")
   ? "Days left in the month:", dDaysLeftM(dDate)
   ? "Days left in the quarter:", dDaysLeftQ(dDate)
   ? "This date is in week #", ltrim(str(dWeekNum(dDate)))
   ?
   ? "END OF DATE FUNCTIONS"
ENDFUNCTION
