/*  QNAME3.C
=========================================================================

    Original program -- QNAME.C

    QNAME.C -- renames ATBBS.QWK in current directory to new file name
    that contains current day and month.
    Written by Martin Leon, Ashton Tate Software Support using the
    Microsoft Quick C compiler.

=========================================================================

    QNAME.C modified to QNAME2.C
    by David J. Semon

    March 22, 1991

    Program modified to:

    1. Compile with Borland Turbo C 2.0 (struct date d) vs Microsoft
       Quick C (dosdate_t today).
    2. Allow any file name to be entered as a command line argument.
    3. Rename the input file to a new file name that contains the first
       three characters of the input file name plus current day, month
       and a sequence letter (A,B,C,D, etc.).

       Examples:     Assume DOS date = 03/22/91
                     Assume first file renamed on that date

                     ATBBS    becomes  ATB0322A.QWK
                     SEMWARE  becomes  SEM0322A.QWK
                     ABCDEFGH becomes  ABC0322A.QWK
                     AB       becomes  AB0322A.QWK
                     A        becomes  A0322A.QWK

    4. If no file name is provided, a message displays correct syntax.
    5. If the file name is not found, a message is displayed saying so.

=======================================================================

   QNAME2.C  Modified to QNAME3.C  By Henry Gerlach on 5-12-93

   1.  remodified to again compile with MS Quick C.

   2.  Program now accepts additional arguments; Additional paths
	   in which to look for a file matching the prospective new name.

   3.  File to be changed need not be in current directory. A path
	   may be included with the name.

   4.  extension need not be .QWK. if no extension is given, .QWK
	   will be assumed.
=======================================================================*/

#include <stdio.h>
#include <io.h>
#include <dos.h>
#include <string.h>
#include <process.h>
FILE *oldfile;
FILE *newfile;
struct dosdate_t today;
char newname[80];
char oldname[80];
char path_newname[99];
char drive[3],dir[40],name[9],ext[4];
char prefix[80],tprefix[4];
int x,exists=0,numpath=2;

/*-------------------------------------------------------------------- */
int main(int argc, char *argv[])
  {
  if(argc < 2)                        /* No argument entered */
    {
    printf("Please enter a file name to rename ...\n");
	printf("Syntax: QNAME3 <filename>\n\n");
    exit(1);
    }
  else
	{
	_splitpath(argv[1],drive,dir,name,ext);  /* break name into components */
	if (!strlen(ext)) strcpy (ext,"QWK\0"); /* If no extension was given,
											 Assume .QWK      */
	if(strlen(name) > 3)         /* If name of file is greater than */
      {                             /*         three chars,            */
	  strncat(tprefix,name,3);  /* Copy first three characters */
      }
    else                            /*            else             */
      {
	  strcpy(tprefix,name);     /* Copy entire string */
	  }
	_makepath (oldname,drive,dir,name,ext);   /* add path back to name */
	_makepath (prefix,drive,dir,tprefix,"\0");  /* add path back to prefix */
    strupr(oldname);                /* Convert name to upper case */
    strupr(prefix);                 /* Convert prefix to upper case */
    }

  /* Make sure file (oldname) exists */
  if((oldfile = fopen(oldname,"rt")) == NULL)
    {
    printf("%s not found in current directory ...\n\n",oldname);
    return 1;
    }
  else
    /* The file exists and is open. Close it */
   fclose(oldfile);

  /* Get today's date */
	_dos_getdate( &today );

  /* x = letter of the alphabet.  Start at "A", ASCII 65 */
  x = 65;

  /*  Use sprintf() to combine the month and day and the letter into
      a file name.  Check to see if it doesn't exist and rename. Do
      this until letter = "Z" */
  do
    {
	sprintf(newname, "%s%02u%02u%c.QWK", prefix, today.month, today.day, x);

	if((newfile = fopen(newname,"rt")) != NULL) exists = 1; /* check current path */
	while (numpath < argc){  /* check altenate paths */
		sprintf (path_newname,"%s%s",argv[numpath],newname);
		if((newfile = fopen(path_newname,"rt")) != NULL) exists = 1;
		numpath++;
	}
	if (!exists)
      {
        /* File name doesn't exist, rename original to unused file name */
	  if(rename(oldname,newname) != 0)
        {
        printf("Error renaming %s to %s\n\n",oldname,newname);
        return 1;
        }
      else
          /* If the rename was succesful, we're done with this loop */
       break;
      }
    else
      /* If the file existed, close it and go to next file name */
	 fclose(newfile);
	 numpath = 2;
	 exists = 0;
    }
  while (++x <= 90);

  /* If more than 26 files exist for today's date, give error message */
  if(x > 90)
    {
	printf("\nUnable to rename beyond %s%02u%02u%c.QWK\n",today.month, today.day, x - 1 );
    return 1;
    }

  /* Rename completed */
  printf("%s renamed to %s\n\n",oldname,newname);
  return 0;
  }
