/* QName -- renames ATBBS.QWK in current directory to new file name
	that contains current day and month.  Written by Martin Leon,
	Ashton Tate Software Support using the Microsoft Quick C compiler.  */

#include <stdio.h>
#include <io.h>
#include <dos.h>

FILE *oldfile;
FILE *newfile;
struct dosdate_t today;

char newname[13];
int x;

int main()
{
   /* Make sure ATBBS.QWK exists */
   if( ( oldfile = fopen( "ATBBS.QWK", "rt" ) ) == NULL ) {
      printf( "\nNo ATBBS.QWK in current directory\n" );
      return 1;
	}
	else
		/* The file exists and is open. Close it */
		fclose( oldfile );

	/* Get today's date */
	_dos_getdate( &today );

	/* x = letter of the alphabet.  Start at "A", ASCII 65 */
	x = 65;

	/* Use sprintf() to combine the month and day and the letter in to
		a file name.  Check to see if it doesn't exist and rename. Do this
		until letter = "Z" */
	do {
      sprintf( newname, "AT%02u%02u%c.QWK", today.month, today.day, x );

		if( ( newfile = fopen( newname, "rt" ) ) == NULL ) {

			/* File name doesn't exist, rename original to unused file name */
			if( rename( "ATBBS.QWK", newname ) != 0 ) {
				printf( "\nError renaming ATBBS.QWK to %s\n" );
				return 1;
			}
			else
				/* If the rename was succesful, we're done with this loop */
				break;
		}
		else
			/* If the file existed, close it and go to next file name */
			fclose( newfile );
   } while ( ++x <= 90 );

	/* If more than 26 files exist for today's date, give error message */
	if( x > 90 ) {
		printf( "\nUnable to rename beyond AT%02u%02u%c.QWK",
			today.month, today.day, x - 1 );
		return 1;
	}

	/* Rename completed */
   printf( "\nATBBS.QWK renamed to %s\n", newname );
   return 0;
}

