/*
	MR/2 - MSG2REP.CMD

	Author: 	Nick Knight
	Created:	03/26/93
	Usage:		msg2rep packet.rep packet.msg
	Purpose:

	The author claims no copyright to this particular REXX script.
    Feel free to copy it and/or use it for other purposes.  I *would*
    like to see the results of any improvements to it.

	US Mail:	Nick Knight, 1823 David Ave.,  Parma, Ohio 44134
	Fidonet:	1:157/2 or 1:/157/200
	Internet:	nick.knight@pcohio.com
	Compuserve: 76066,1240
	BBS:		Private messages on Nerd's Nook, 356-1772 or 356-1872
*/

/***********************************************************************/
/*		A R C H I V E R 	C O M M A N D	 D E F I N I T I O N S	   */
/***********************************************************************/
/*	To add support for a new unpacker, simply supply a new command
	definition here.  The file name to unpack will be appended to
	the end of the supplied command.  You can customize in more detail
	by modifying the code directly, if need be.
*/

/*path = 'c:\utility\' */
path = ''

zip_command =		'pkzip'
infozip_command =	'zip -j'
arj_command =		'arj u'
zoo_command =		'zoo u'
lharc_command = 	'lha u'
lha_command =		'lh a /i'
/*lha_command = 	  'lh a /i' */      /* for lh2 for OS/2 */
arc_command =		'arc u'

noidfile_command =	zip_command

/***********************************************************************/
/*					U N Q W K	 F I L E N A M E					   */
/***********************************************************************/
/*
	Returns -1 if it the file "archive.id" is bad or non-existent.
	Otherwise, the "archive_id" is returned (1 -> 6).
*/

parse arg filename msgfile

idfile = "archiver.id"

/*
04/02/93 - if no packet entry, unarchiver wasn't used - default to something
if stream(idfile,'c','query exists') = "" then do
	return -1
end
*/

if stream(idfile,'c','query exists') = "" then do
	archiver_id = -1
end
else do
	archiver_id = linein(idfile,1,1)
	status = lineout(idfile)
end

/*if archiver_id = 1 then archiver_id = 7 */

select										/* execute the corresponding command */
	when archiver_id = 1 then path || zip_command filename msgfile
	when archiver_id = 2 then path || arj_command filename msgfile
	when archiver_id = 3 then path || zoo_command filename msgfile
	when archiver_id = 4 then path || lharc_command filename msgfile
	when archiver_id = 5 then path || lha_command filename msgfile
	when archiver_id = 6 then path || arc_command filename msgfile
	when archiver_id = 7 then do
		parse arg filebase"."ext
		path || infozip_command filebase msgfile
		if RC = 0 then do
			'copy' filebase||".zip" filebase||".rep"
		end
		if RC = 0 then do
			'del' filebase||".zip"
		end
    end
	when archiver_id = -1 then path || noidfile_command filename msgfile
	otherwise
		say "UNKNOWN ARCHIVE TYPE: " filename "(" archiver_id ")"
		RC = -1
end

if RC <> 0 then return -1

return 0

