{************************************************}
{                                                }
{   Turbo Pascal for Windows                     }
{   Windows 3.1 Demo program                     }
{   Copyright (c) 1992 by Borland International  }
{                                                }
{************************************************}
{$N+}
{$R TTFonts}

program TrueTypeFontLab;

uses WObjects, WinTypes, WinProcs, Strings, Win31, CommDlg, TTFCnst;

type

  PFontWindow = ^TFontWindow;
  TFontWindow = object(TWindow)
    MainFontRec,
    CornerFontRec,
    BorlandFontRec:  TLogFont;
    FanColor: array [0..9] of TColorRef;
    ShadowAll: Boolean;
    ShowAlignmentMarks: Boolean;
    constructor Init(AParent: PWindowsObject; ATitle: PChar);
    procedure Paint(DC: HDC; var PS: TPaintStruct); virtual;
    procedure CMAbout(var Msg: TMessage); virtual cm_First + cm_About;
    procedure CMShadows(var Msg: TMessage); virtual cm_First + cm_Shadows;
    procedure CMAlignmentMarks(var Msg: TMessage); virtual cm_First + cm_AlignmentMarks;
    procedure CMFonts(var Msg: TMessage); virtual cm_First + cm_Fonts;
    procedure WMGetMinMaxInfo(var Msg: TMessage); virtual wm_First + wm_GetMinMaxInfo;
  end;

constructor TFontWindow.Init(AParent: PWindowsObject; ATitle: PChar);
begin
  TWindow.Init(AParent, ATitle);
  Attr.Menu := LoadMenu(HInstance, PChar(100));

  with MainFontRec do  { Init the logical font record for the 'fan' text }
  begin
    lfHeight:= 26;
    lfWidth:= 10;
    lfEscapement:= 0;
    lfOrientation:= 0;
    lfWeight:= fw_Bold;
    lfItalic:= 0;
    lfUnderline:= 0;
    lfStrikeOut:= 0;
    lfCharSet:= ANSI_CharSet;
    lfOutPrecision:= Out_Default_Precis;
    lfClipPrecision:= Clip_Default_Precis;
    lfQuality:= Proof_Quality;
    lfPitchAndFamily:= Variable_Pitch or FF_Roman;
    StrCopy(lfFaceName,'Times New Roman');
  end;

  CornerFontRec := MainFontRec;

  BorlandFontRec := MainFontRec;
  with BorlandFontRec do
  begin
    lfHeight:= 60;
    lfWidth:= 0;   { choose best width for this height }
    lfWeight:= 900;
    StrCopy(lfFaceName, 'Arial');
  end;

  { Array of colors used to color the fan text }
  FanColor[0] := RGB(255,0,0);
  FanColor[1] := RGB(128,0,0);
  FanColor[2] := RGB(255,128,0);
  FanColor[3] := RGB(80,80,0);
  FanColor[4] := RGB(80,255,0);
  FanColor[5] := RGB(0,128,0);
  FanColor[6] := RGB(0,128,255);
  FanColor[7] := RGB(0,0,255);
  FanColor[8] := RGB(128,128,128);
  FanColor[9] := RGB(255,0,0);

  ShadowAll := False;
  ShowAlignmentMarks := False;
end;


procedure TFontWindow.Paint(DC: HDC; var PS: TPaintStruct);
const
  ArcText = 'TrueType';
  FanText = 'Turbo Pascal for Windows';
  BorlandText = 'Borland';
  Radius = 100;

type
  TTextExtent = record
    W, H: Word;
  end;

var
  FontRec: TLogFont;
  FontMetric: TOutlineTextMetric;
  FontHeight : integer;
  d: Word;
  x,y,j,k: Integer;
  Theta : real;
  P: PChar;
  Deg2Rad: Extended;
  R: TRect;
  BaseWidth,
  DesiredExtent,
  FanTextLen: Word;
  TE: TTextExtent;
begin

  P := ArcText;
  Deg2Rad := PI / 18;
  FanTextLen := StrLen(FanText);

  SaveDC(DC);

  FontRec := CornerFontRec;
  SetBkMode(DC, Transparent);
  SetTextColor(DC, RGB(128,128,128));
  FontRec.lfHeight := FontRec.lfHeight * 2;
  FontRec.lfWidth := Trunc(FontRec.lfWidth * 2.1);
  SelectObject(DC, CreateFontIndirect(FontRec));
  TextOut(DC, 18, 5, 'T', 1);
  SetTextColor(DC, RGB(0,0,0));
  TextOut(DC, 32, 13,'T', 1);

  GetClientRect(HWindow, R);
  FontRec := MainFontRec;
  DeleteObject(SelectObject(DC, CreateFontIndirect(FontRec)));
  GetOutlineTextMetrics(DC, sizeof(FontMetric), FontMetric);
  FontHeight := FontMetric.otmTextMetrics.tmHeight;
  SetViewportOrg(DC, FontHeight+2, 0);
  Dec(R.Right, FontHeight+2);
  BaseWidth := LoWord(GetTextExtent(DC, FanText, FanTextLen));

  SelectObject(DC, GetStockObject(Null_Brush));
  if ShowAlignmentMarks then Ellipse(DC, -R.right, -R.Bottom, R.Right, R.Bottom);
  Ellipse(DC, -(Radius-5), -(Radius-5), (Radius-5), Radius-5);
  Ellipse(DC, -(Radius-10), -(Radius-10), (Radius-10), Radius-10);

  SetTextColor(DC, FanColor[0]);
  for d:= 27 to 36 do
  begin
    x := Round(Radius * cos(d * Deg2Rad));
    y := Round(Radius * sin(-d * Deg2Rad)); { -d because y axis is inverted }

    Theta := -d * deg2rad;
    if (X <> 0) then
      Theta := ArcTan((R.Right / R.Bottom) * (Y / X));
    j := Round(R.Right * cos(Theta));
    k := Round(R.Bottom * sin(Theta));

    if ShowAlignmentMarks then
    begin
      MoveTo(DC, x,y);
      LineTo(DC, j,k);
    end;

    { Calculate how long the displayed string should be }
    DesiredExtent := Round(Sqrt(Sqr(x*1.0-j) + Sqr(y*1.0-k))) - 5;
    FontRec := MainFontRec;
    FontRec.lfEscapement := d * 100;
    FontRec.lfWidth := Trunc((FontMetric.otmTextMetrics.tmAveCharWidth) * (DesiredExtent / BaseWidth));
    DeleteObject(SelectObject(DC, CreateFontIndirect(FontRec)));
    Longint(TE) := GetTextExtent(DC, FanText, FanTextLen);

    { Shave off some character width until the string fits }
    while (TE.W > DesiredExtent) and (FontRec.lfWidth <> 0) do
    begin
      Dec(FontRec.lfWidth);
      DeleteObject(SelectObject(DC, CreateFontIndirect(FontRec)));
      Longint(TE) := GetTextExtent(DC, FanText, FanTextLen);
    end;

    { Expand the string if necessary to make it fit the desired extent }
    if TE.W < DesiredExtent then
      SetTextJustification(DC,DesiredExtent - TE.W, 3);
    if ShadowAll then
    begin
      SetTextColor(DC, RGB(0,0,0));
      TextOut(DC, x+2, y+1, FanText, FanTextLen);
    end;
    SetTextColor(DC, FanColor[d - 27]);
    TextOut(DC, x, y, FanText, FanTextLen);
    SetTextJustification(DC,0,0);  { clear justifier's internal error accumulator }

    if P[0] <> #0 then
    begin
      FontRec := CornerFontRec;
      FontRec.lfEscapement := (d+10) * 100;
      FontRec.lfWidth := 0;
      DeleteObject(SelectObject(DC, CreateFontIndirect(FontRec)));
      SetTextColor(DC, 0);
      x := Round((Radius - FontHeight - 5) * cos(d * Deg2Rad));
      y := Round((Radius - FontHeight - 5) * sin(-d * Deg2Rad));
      TextOut(DC, x, y, P, 1);
      inc(P);
    end;
  end;

  DeleteObject(SelectObject(DC, CreateFontIndirect(BorlandFontRec)));
  Longint(TE) := GetTextExtent(DC, BorlandText, StrLen(BorlandText));
  SetTextColor(DC, RGB(0,0,0));
  TextOut(DC, R.Right - TE.W, R.Bottom - TE.H, BorlandText, StrLen(BorlandText));
  SetTextColor(DC, RGB(255,0,0));
  TextOut(DC, R.Right - TE.W - 5, R.Bottom - TE.H, BorlandText, StrLen(BorlandText));

  DeleteObject(SelectObject(DC, GetStockObject(System_Font)));
  RestoreDC(DC, -1);
end;

procedure TFontWindow.CMAbout(var Msg: TMessage);
begin
  Application^.ExecDialog(new(PDialog, Init(@Self, 'About')));
end;

procedure TFontWindow.CMShadows(var Msg: TMessage);
begin
  ShadowAll := not ShadowAll;
  if ShadowAll then
    CheckMenuItem(Attr.Menu, cm_Shadows, mf_ByCommand or mf_Checked)
  else
    CheckMenuItem(Attr.Menu, cm_Shadows, mf_ByCommand or mf_UnChecked);

  { Erase if going Shadow -> no Shadow }
  InvalidateRect(HWindow, nil, not ShadowAll);
end;

procedure TFontWindow.CMAlignmentMarks(var Msg: TMessage);
begin
  ShowAlignmentMarks := not ShowAlignmentMarks;
  if ShowAlignmentMarks then
    CheckMenuItem(Attr.Menu, cm_AlignmentMarks, mf_ByCommand or mf_Checked)
  else
    CheckMenuItem(Attr.Menu, cm_AlignmentMarks, mf_ByCommand or mf_UnChecked);

  { Erase if going marks -> no marks }
  InvalidateRect(HWindow, nil, not ShowAlignmentMarks);
end;

procedure TFontWindow.CMFonts(var Msg: TMessage);
var
  CF: TChooseFont;
  FontRec: TLogFont;
begin
  FontRec := MainFontRec;
  FillChar(CF, Sizeof(CF), #0);
  with CF do
  begin
    lStructSize := SizeOf(TChooseFont);
    HWndOwner := HWindow;
    Flags := cf_AnsiOnly or cf_TTOnly or CF_ScreenFonts;
    nFontType := Screen_FontType;
    lpLogFont := @FontRec;
  end;
  if ChooseFont(CF) then
  begin
    { Only get the font name - we don't care what size the user selected }
    StrCopy(MainFontRec.lfFaceName, FontRec.lfFaceName);
    InvalidateRect(HWindow, nil, True);
  end;
end;

procedure TFontWindow.WMGetMinMaxInfo(var Msg: TMessage);
type
  TPointArray = array [0..4] of TPoint;
  PPointArray = ^TPointArray;
begin
  { Limit the minimum size of the window to 300x300, so the fonts don't
    get too small }
  PPointArray(Msg.LParam)^[3].X := 300;
  PPointArray(Msg.LParam)^[3].Y := 300;
end;

type
  { Define a TApplication descendant }
  TFontApp = object(TApplication)
    procedure InitMainWindow; virtual;
  end;

{ Construct the TFontApp's MainWindow object }
procedure TFontApp.InitMainWindow;
begin
  MainWindow := New(PFontWindow, Init(nil, 'TrueType Font lab'));
end;

{ Declare a variable of type TFontApp }
var
  FontApp: TFontApp;

{ Run the FontApp }
begin
  FontApp.Init('TrueType Font Lab');
  FontApp.Run;
  FontApp.Done;
end.
