/*	Copyright (c) 1989 Citadel	*/
/*	   All Rights Reserved    	*/

/* #ident	"@(#)krtmp.c	1.4 - 90/06/21" */

#include <blkio.h>	/* ansi compatibility macros */

/* ansi headers */
#include <errno.h>
/*#include <stddef.h>*/
#include <stdio.h>

/*man---------------------------------------------------------------------------
NAME
    krtmp - K&R C temporary ANSI functions

DESCRIPTION
    This file contains ANSI functions required by cbase which may not
    be available with K&R compilers.

------------------------------------------------------------------------------*/
#if __STDC__ != 1
/* memmove:  memory move */
void *memmove(t, s, n)
void *t;
void *s;
size_t n;
{
	void *buf = NULL;
	if ((buf = calloc((size_t)1, n)) == NULL) return NULL;
	memcpy(buf, s, n);
	memcpy(t, buf, n);
	free(buf);
	return t;
}

extern char *sys_errlist[];
extern int sys_nerr;

void perror(s)
char *s;
{
	if (s != NULL) {
		fputs(s, stderr);
		fputs(": ", stderr);
	}
	if (errno >= 0 && errno < sys_nerr) {
		fprintf(stderr, "%s\n", sys_errlist[errno]);
	} else {
		fprintf(stderr, "Error number %d\n", errno);
	}

	return;
}

int link();
int unlink();

int remove(filename)
char *filename;
{
	if (unlink(filename) == -1) {
		return -1;
	}

	return 0;
}

int rename(file1, file2)
const char *file1;
const char *file2;
{
	if (link(file1, file2) == -1) {
		return -1;
	}
	if (unlink(file1) == -1) {
		return -1;
	}

	return 0;
}
#endif	/* #if __STDC__ != 1 */
