/*
 *  Blinker 2.0 Swap demo
 *
 *          C version
 *
 *  Copyright (c) Blink inc, 1992
 *
 *
 *  cl -AL -c swapdemo.c ;
 *
 */

#include "blinker.h"

#define TRUE    1
#define FALSE   0

void yesno(int) ;

void main()
{
 int status ;

 printf("--------------------------------------------\n");
 printf("C Swap function Example\n");
 printf("=======================\n");
 printf("\n");

 printf("Default settings:\n\n");
 printf("Use EMS                        : "); yesno(SWPUSEEMS(FALSE));
 printf("Use XMS                        : "); yesno(SWPUSEXMS(FALSE));
 printf("Use UMB                        : "); yesno(SWPUSEUMB(FALSE));
 printf("Save/restore video mode        : "); yesno(SWPVIDMDE(FALSE));
 printf("Save/restore directory         : "); yesno(SWPCURDIR(FALSE));
 printf("Prevent reboots                : "); yesno(SWPNOBOOT(FALSE));
 printf("Wait for keypress              : "); yesno(SWPGETKEY(FALSE));
 printf("Display message                : "); yesno(SWPDISMSG(FALSE));
 printf("Program already running        : "); yesno(SWPGETPID("test.c"));
 printf("\n");

 /* enable use of EMS / XMS / UMBs */

 SWPUSEEMS(TRUE);
 SWPUSEXMS(TRUE);
 SWPUSEUMB(TRUE);

 /* save / restore current directory */

 SWPCURDIR(TRUE);

 
 if (SWPGETPID("test.c"))
    {
     printf("Terminating with code 255 (previous 'swapdemo.c' already running)\n");
     printf("Type (EXIT) to return to previous 'swapdemo.c'\n");
     exit(255);
    }
 else
    {

     /* Set a program ID */

     printf("Set program ID to 'test.c'     : "); yesno(SWPSETPID("test.c"));
     printf("\n\n");

     printf("Shelling to DOS...(EXIT to return)\n\n");
     printf("** Now run this program again to see SWPGETPID() **\n");

     status = SWPRUNCMD("",0,"","");

     printf("Back from shell - status is    : %d\n",status);
     printf("Major error code               : %d\n",SWPERRMAJ());
     printf("Minor error code               : %d\n",SWPERRMIN());

     printf("Child return code              : %d\n\n",SWPERRLEV());

     printf("End of test.\n");
     printf("--------------------------------------------\n");
     exit(47);
    }
}

void yesno(flag)
int flag;
{
  if (flag)
  {
    printf("Yes\n");
  }
  else
  {
    printf("No \n");
  }
}

