*****************************************************************************
* Blinker 2.0 swap function demo
*
* Clipper S'87 / 5.01
*
* Compile: Clipper swapdemo -m
*
*****************************************************************************

enable  = .t.
disable = .f.

  ? "Clipper Swap example"
  ? "===================="
  ?
  ? "Swap defaults      "
  ?
  ? "Use EMS memory                  : ",SWPUSEEMS(disable)
  ? "Use XMS memory                  : ",SWPUSEXMS(disable)
  ? "Use UMBs                        : ",SWPUSEUMB(disable)
  ? "Save/restore video mode         : ",SWPVIDMDE(disable)
  ? "Save/restore directory          : ",SWPCURDIR(disable)
  ? "Display message                 : ",SWPDISMSG(disable)
  ? "Wait for keypress               : ",SWPGETKEY(disable)
  ? "Suppress <Ctrl><Alt><Del>       : ",SWPNOBOOT(disable)
  ?

  ? "Program already running?        : ",SWPGETPID("swapdemo.prg")
  ? "Set program ID to swapdemo.prg  : ",SWPSETPID("swapdemo.prg")
  ?

  * enable ems / xms / umbs

  i = SWPUSEEMS(enable)
  i = SWPUSEXMS(enable)
  i = SWPUSEUMB(enable)

  * save / restore current directory and video mode
  * video buffer contents are not saved

  i = SWPCURDIR(enable)
  i = SWPVIDMDE(enable)

  if ! SWPGETPID("swapdemo.prg")
     * if we're not running already

     ? "Shelling to DOS..."
     ? "Run swapdemo again to see BLIGETPID."
     ? "-------------------------------------------------------------------------"

     * status = SWPRUNCMD(ChildProg, Memory, Shell Directory, Temporary directory)

     i = SWPRUNCMD( "", 0, "", "")

     ? "-------------------------------------------------------------------------"
     ? "Back from shell, status is      : ",i
     ? "Major error code is             : ",SWPERRMAJ()
     ? "Minor error code is             : ",SWPERRMIN()
     ? "Child process return code was   : ",SWPERRLEV()

  else
     * we're already running, terminate the program
     ? "Terminating (swapdemo.prg already executing)"
     ? "Type EXIT to return to previous swapdemo.prg"
  endif

