#include <scl1.h>
#include <scl1clor.h>
#include <scl1keys.h>

char *Info[]={
" BigCursor         - Changes the cursor size to a block.",
" Center            - Centers a string horizontally.",
" Cls               - Clears a screen area.",
" CursorOff         - Turns the cursor off.",
" CursorOn          - Turns the cursor on (cursor visible).",
" DrawItemList      - Draws an item list to the screen.",
" GetCurLine        - Returns the current cursor row position.",
" GetCurSize        - Returns the current cursor size.",
" ScrollUp          - Scrolls up a screen area.",
" SetCurPos         - Sets the cursor position.",
" SetCurSize        - Sets the cursor size.",
" SetVideoMode      - Sets the video mode.",
" SetVideoPage      - Sets the video page.",
" SetVideo25        - Sets the display mode to 25 lines.",
" Shadow            - Draws a shadow effect to a screen area.",
" Video             - Detects if the video adapter in use is",
"                     either Monochrome, CGA or EGA.",
" WriteCharBlock    - Writes a block of characters.",
0};

unsigned int ExitK[]={ESC,ENTER,0};

main()
{
int i;
SWData sw;  /* Scroll Window structure */

CursorOff();                 /* Turn off cursor */
InitMouse(IM_SHOW);
Cls(WHITE_BLACK,CLS_ALL);
ScrollWindow(SW_INIT,&sw);   /* Initialize Scroll Window */

sw.UpperRow=4;               /* Change default window size */
sw.LeftCol=4;
sw.LowerRow=18;
sw.RightCol=75;
sw.ExitKeys=ExitK;
sw.Array=Info;
sw.Title="[ Information ]";

ScrollWindow(SW_DRAW,&sw);   /* Now, draw the Scroll Window */
do                           /* Browse window until an exit key is pressed */
    {
    i=ScrollWindow(SW_ACTIVE,&sw);
    if(i==SW_ILLEGAL_KEY)
        SW_MoveTo(&sw);
    }while(i!=SW_EXIT_KEY && i!=SW_MOUSE_EVENT);
CursorOn();
Cls(7,CLS_ALL);
}
