#include <scl1.h>
#include <scl1keys.h>
#include <scl1clor.h>

 /*************************************************************
   Shows the use of LineEditor function. See file LINEDIT2.C
   for another example of LineEditor */

unsigned int ExitKeys[]={ENTER,ESC,0};

main()
{
LEData led;
int Mess;
char buffer[81];

Cls(WHITE_BLACK,CLS_ALL);               /* clear screen */
memset(buffer,0,sizeof(buffer));        /* initialize buffer */

/* initialize Line Editor structure */

LineEditor(LE_INIT,&led);

/* modify prompt and field position */

led.PRow=led.FRow=12;
led.PCol=25;
led.FCol=35;
led.FLength=20;    /* the field's screen length is of 20 characters */
led.FSize=80;      /* but up to 80 characters can be entered, the data*/
				   /* entry field will scroll automatically */

led.Prompt="Filename:";                 /* prompt */
led.CType=CC_PATH | CC_CAPITALIZE;      /* type of valid characters */
led.Buffer=buffer;                      /* use our buffer */
led.ExitKeys=ExitKeys;                  /* our defined exit keys */
PushCursor();                           /* save cursor */
LineEditor(LE_DRAW,&led);               /* draw */

  /* Main loop: send ACTIVE message, LineEditor constantly
	 returns information */

do
	 {
	 Mess=LineEditor(LE_ACTIVE,&led);
	 if(Mess==LE_ILLEGAL_KEY)          /* illegal key? */
		  TSound(440,10);              /* beep */

	 /* loop until an exit key is pressed */

	 }while(Mess != LE_EXIT_KEY);

Cls(WHITE_BLACK,CLS_ALL);               /* clear screen */
}