#include <scl1.h>

/* This file shows the use of GetCharSet and ModifyCharSet to modify
   VGA and EGA character definition tables */

   /* copyright symbol for the VGA */

char VGAcopyr[]={
0x00,0x00,0x00,0x0f,0x18,0x33,0x26,0x26,0x26,0x26,0x33,0x18,0x0f,0x00,0x00,0x00,
0x00,0x00,0x00,0xf8,0x0c,0xe6,0x22,0x02,0x02,0x22,0xe6,0x0c,0xf8,0x00,0x00,0x00};

   /* copyright symbol for the EGA */

char EGAcopyr[]={
0x00,0x00,0x0f,0x18,0x33,0x26,0x26,0x26,0x26,0x33,0x18,0x0f,0x00,0x00,
0x00,0x00,0xf8,0x0c,0xe6,0x22,0x02,0x02,0x22,0xe6,0x0c,0xf8,0x00,0x00};

main()
{
unsigned char OldChar[32 * 2]; /* Buffer */

VideoConfig();
if(VC_Monitor != VC_VGA && VC_Monitor != VC_EGA)
    {
    printf("Your monitor does not support character modification\n");
    exit(-1);
    }

/* we'll change ASCII characters 192-193 into a copyright symbol but first 
   we'll copy the original characters so that they can be later restored */

GetCharSet(192,2,OldChar);

/*   Modify character definition */

if(VC_Monitor==VC_VGA)

    ModifyCharSet(16,192,2,VGAcopyr);

else

    ModifyCharSet(14,192,2,EGAcopyr);

/*   Write the new copyright character character */

printf("The new copyright symbol \xc0\xc1, press any key...\n");

WaitKeyMouse();

/* restore characters */

ModifyCharSet(32,192,2,OldChar);

printf("Symbols restored\n");
}






