unit Pdrivers;

INTERFACE

 (*   drivers  *)

 const Star_SR9   = 0;
       IBM9       = 1;  (* IBM GraphPrinter,IBM ProPrinter  *)
       EPSON9     = 1;     (* EPSON (graphic mode: Esc,'K'/'L'/'Y'/'Z') *)
       EPSON9II   = 2;     (* EPSON (graphic mode: Esc,'*',n) *)
       PANASONIC9 = 3;     (* Panasonic KX-P1124 - not tested *)
       IBM9c      = 4;     (* IBM ProPrinter (color) *)
       EPSON9c    = 4;     (* EPSON (color) (graphic mode: Esc,'K'/'L'/'Y'/'Z') *)
       EPSON9IIc  = 5;     (* EPSON (color) (graphic mode: Esc,'*',n) *)
       EPSON24    = 6;     (* 24 pins EPSON compatible printer *)
       IBM24      = 7;     (* 24 pins IBM compatible printer *)
       EPSON24c   = 8;     (* 24 pins EPSON compatible color printer *)
                           (*  not tested *)
       IBM24c     = 9;     (* 24 pins IBM compatible color printer *)
                           (*  not tested *)
       PaintJet   = 10;    (* Paint Jet  *)
       HPPaintJet = 11;    (* HP Paint Jet *)
       LaserJet   = 12;    (* Laser Jet *)
       HPLJII     = 13;    (* HP Laser Jet *)

 (* modes for particular drivers *)

   (* EPSON9   *)
      const  EPSON9_60x72     = 0;
      const  EPSON9_120x72    = 1;
      const  EPSON9_120x216   = 2;
      const  EPSON9_240x216   = 3;
   (* STAR_SR9    *)
      const  STAR_SR9_60x72       = 0;
      const  STAR_SR9_120x72      = 1;
      const  STAR_SR9_120x144     = 2;
      const  STAR_SR9_240x144     = 3;
   (* IBM9     *)
      const  IBM9_60x72       = 0;
      const  IBM9_120x72      = 1;
      const  IBM9_120x216     = 2;
      const  IBM9_240x216     = 3;
   (* EPSON24  *)
      const  EPSON24_60x180    = 0;
      const  EPSON24_120x180   = 1;
      const  EPSON24_180x180   = 2;
      const  EPSON24_360x180   = 3;
      const  EPSON24_360x360   = 4;
   (* IBM24    *)
      const  IBM24_60x180    = 0;
      const  IBM24_120x180   = 1;
      const  IBM24_180x180   = 2;
      const  IBM24_360x180   = 3;
   (* PaintJet   *)
      const  PaintJet_90x90       = 0;
      const  PaintJet_180x180     = 1;
      const  PaintJet_90x90c      = 2;
      const  PaintJet_180x180c    = 3;
   (* HPPJ   *)
      const  HPPJ_90x90       = 0;
      const  HPPJ_180x180     = 1;
      const  HPPJ_90x90c      = 2;
      const  HPPJ_180x180c    = 3;
   (* LaserJet   *)
      const  LaserJet_75x75      =  0;
      const  LaserJet_100x100    =  1;
      const  LaserJet_150x150    =  2;
      const  LaserJet_300x300    =  3;
   (* HPLJII   *)
      const  HPLJII_75x75      =  0;
      const  HPLJII_100x100    =  1;
      const  HPLJII_150x150    =  2;
      const  HPLJII_300x300    =  3;



Procedure PRT_LinkDriversDefinitions;
Const PRT__DriversPtr: pointer = nil;

IMPLEMENTATION

Procedure PRT_LinkDriversDefinitions;

         External; {$L Drivers <-------------------------------- }
         { If you didn't compile file Drivers.asm you don't have
           DRIVERS.OBJ  file. Delete or rename this file in that
           case and make will take existing TPU file. }
         { ------------------------------------------------------ }
END {unit Pdrivers}.