/*
   Printer BGI driver C interface
   Copyright (c) 1991 A. Resztak
 */
 /*   Header file */

#if   !defined(__LARGE__) && !defined(__HUGE__)
   #error PRTgraph library will run only in LARGE memory model.
#endif

#if   !defined(_PRT__pascal)
      #define  _PRT__pascal
#endif


 #define PRT_NO_MEMORY           1
 #define PRT_WRONG_PARAMETERS    2
 #define PRT_NOT_INITIALIZED     3
 #define PRT_IO_ERROR            4
 #define PRT_ERROR               5


 /*   drivers  */

 #define STAR_SR9    0  /* Epson ????, Star SR  */
 #define IBM9        1     /* IBM GraphPrinter, ProPrinter  */
 #define EPSON9      1     /* EPSON,CITIZEN ( graphic mode: Esc,'K'/'L'/'Y'/'Z' ) */
 #define EPSON9II    2     /* EPSON,CITIZEN ( graphic mode: Esc,'*',n )     */
 #define PANASONIC9  3     /* Panasonic KX-P1124 - not tested */
 #define IBM9c       4     /* IBM ProPrinter (color) */
 #define EPSON9c     4     /* EPSON (color) (graphic mode: Esc,'K'/'L'/'Y'/'Z') */
 #define EPSON9IIc   5     /* EPSON (color) - (graphic mode: Esc,'*',n) */
 #define EPSON24     6     /* 24 pins EPSON compatible printer */
 #define IBM24       7     /* 24 pins IBM compatible printer */
 #define EPSON24c    8     /* 24 pins EPSON compatible color printer */
                           /*  not tested */
 #define IBM24c      9     /* 24 pins IBM compatible color printer */
                           /*  not tested */
 #define PaintJet    10    /* general Paint Jet  */
 #define HPPaintJet  11    /* HP Paint Jet */
 #define LaserJet    12    /* Laser Jet    */
 #define HPLJII      13    /* HP Laser Jet */
 /* #define HPLJIII     11  */
 /* #define POSTSCRIPT  12  */
 /* #define ROLANDP  13     */

 /* modes for particular drivers */
   /* EPSON9   */
      #define  EPSON9_60x72      0
      #define  EPSON9_120x72     1
      #define  EPSON9_120x216    2
      #define  EPSON9_240x216    3
   /* STAR_SR9    */
      #define  STAR_SR9_60x72        0
      #define  STAR_SR9_120x72       1
      #define  STAR_SR9_120x144      2
      #define  STAR_SR9_240x144      3
   /* IBM9     */
      #define  IBM9_60x72        0
      #define  IBM9_120x72       1
      #define  IBM9_120x216      2
      #define  IBM9_240x216      3
   /* EPSON24  */
      #define  EPSON24_60x180     0
      #define  EPSON24_120x180    1
      #define  EPSON24_180x180    2
      #define  EPSON24_360x180    3
      #define  EPSON24_360x360    4
   /* IBM24    */
      #define  IBM24_60x180     0
      #define  IBM24_120x180    1
      #define  IBM24_180x180    2
      #define  IBM24_360x180    3
   /* PaintJet   */
      #define  PaintJet_90x90        0
      #define  PaintJet_180x180      1
      #define  PaintJet_90x90c       2
      #define  PaintJet_180x180c     3
   /* HPPJ   */
      #define  HPPJ_90x90        0
      #define  HPPJ_180x180      1
      #define  HPPJ_90x90c       2
      #define  HPPJ_180x180c     3
   /* LaserJet   */
      #define  LaserJet_75x75        0
      #define  LaserJet_100x100      1
      #define  LaserJet_150x150      2
      #define  LaserJet_300x300      3
   /* HPLJII   */
      #define  HPLJII_75x75        0
      #define  HPLJII_100x100      1
      #define  HPLJII_150x150      2
      #define  HPLJII_300x300      3


 /*   F U N C T I O N S    P R O T O T Y P E S  */

#define  PRT__FAR_DATA    /* far */
#define  PRT__FAR_PTR        far
#define  PRT__FAR_PROC    far
#if !ForPascal
    #define  PRT__HUGE_PROC   huge
#else
    #define  PRT__HUGE_PROC   far
#endif


#ifdef __cplusplus
extern "C" {
#endif

int PRT__HUGE_PROC pascal PRT_SetDriver ( unsigned drv, unsigned mode,
                                     unsigned width, unsigned height,
                                     unsigned options );
   #define  PRT_NORMAL     0
   #define  PRT_ROTATE     1
   #define  PRT_INVERSE    2
   #define  PRT_REVERSE    2

// #if ForPascal
   typedef int far *PRT__handleT; /* pointer to Pascal File */
// #else
//   typedef int   PRT__handleT;
// #endif

 /* Procedures which may be called before initializing PBGI */
int PRT__HUGE_PROC pascal PRT_Buffer ( void far *address, long size, int usable );
int PRT__HUGE_PROC pascal PRT_EMSBuffer ( int EMShandle, long size, int usable );
int PRT__HUGE_PROC pascal PRT_XMSBuffer ( int XMShandle, long size, int usable );
int   PRT__HUGE_PROC pascal   PRT_SetBuffer ( long size, unsigned BufOpt );
      #define  NotUseEMS   1
      #define  NotUseXMS   2
 // int PRT__HUGE_PROC pascal PRT_DefineWorld ( unsigned MaxX, unsigned MaxY );
 int  PRT__HUGE_PROC pascal   PRT_SetOutName ( const char PRT__FAR_PTR * DeviceName );
 int  PRT__HUGE_PROC pascal   PRT_SetMargins ( int left, int top );
 int  pascal PRT__HUGE_PROC   PRT_RescaleFillPattern ( int r );
                        /* 0 = never, 1 = always , -1 = at high densities only */

 /* Procedure allocates PRT buffer, initializes PBGI, calls Draw(),
    closes PBGI, prints picture, and frees the buffer.
    All above is done neccesary number of times to print
    entire picture. */
int PRT__HUGE_PROC pascal PRT_PrintBGI (
                              int far * graphdriver, int far *graphmode,
                              const char far *pathtodriver,
                              int ( _PRT__pascal PRT__HUGE_PROC  (*Draw)
                                  (void PRT__FAR_PTR * UserPointer) ),
                              void PRT__FAR_PTR* UserPointer );

       /* Various informing procedures */
   /* May be allways called   */
 int  PRT__HUGE_PROC pascal   PRT_MaxDriver ( void );
 int  PRT__HUGE_PROC pascal   PRT_DriverName ( unsigned driverno, char PRT__FAR_PTR * PRT__FAR_PTR * name_ptr  );
 int  PRT__HUGE_PROC pascal   PRT_MaxMode ( unsigned driverno, int PRT__FAR_PTR *maxmode );
 int  PRT__HUGE_PROC pascal   PRT_ModeName ( unsigned driverno, int modeno,
                        char PRT__FAR_PTR * PRT__FAR_PTR * name_ptr );
 int  PRT__HUGE_PROC pascal   PRT_DriverNo ( void );
 int  PRT__HUGE_PROC pascal   PRT_ModeNo ( void );
 char far * PRT__HUGE_PROC pascal   PRT_grapherrormsg ( int errorcode );

   /*  May be called only after PRT_SetDriver */
 long PRT__HUGE_PROC pascal   PRT_BufferNeeded ( int x1, int y1, int x2, int y2 );
 long PRT__HUGE_PROC pascal   PRT_XMSBufferNeeded ( int x1, int y1, int x2, int y2 );
 int  PRT__HUGE_PROC pascal   PRT_Resolution ( int PRT__FAR_PTR *Xres, int PRT__FAR_PTR *Yres );


 /* Procedure initializes PBGI, calls Draw(), closes PBGI,
    DOES NOT print picture, and DOES NOT allocate or free the buffer */
int PRT__HUGE_PROC pascal  PRT_BuildBitMap (
                              int far * graphdriver, int far *graphmode,
                              const char far *pathtodriver,
                              int x1,int y1, int x2,int y2,
                              int ( _PRT__pascal PRT__HUGE_PROC  (*Draw)
                                  (void PRT__FAR_PTR * UserPointer) ),
                              void PRT__FAR_PTR* UserPointer );

#if ForPascal
   int PRT__HUGE_PROC pascal PRT_Send( const char far *s);
#else
   int PRT__HUGE_PROC pascal PRT_Send( const char far *s, unsigned slen);
#endif

/* Procedures which may be called before freeing the buffer */
int PRT__HUGE_PROC pascal PRT_InitPrt ( PRT__handleT handle );
int PRT__HUGE_PROC pascal PRT_EndPrt ( PRT__handleT handle );
int PRT__HUGE_PROC pascal PRT_PrintBuffer (PRT__handleT handle);

unsigned PRT__HUGE_PROC pascal  PRT_getpixel ( int x, int y );
void  PRT__HUGE_PROC pascal   setfillpattern16 ( char PRT__FAR_PTR * upattern, int color );
void  PRT__HUGE_PROC pascal   getfillpattern16 ( char PRT__FAR_PTR * upattern );
void  PRT__HUGE_PROC pascal   setcharsize_Inch (int width, int height);
      /* Sets char size in 1/1000 inch but is version dependent.
         Might cause link errors in versions other than BC++ 2.0 or 3.0 */
void  PRT__HUGE_PROC pascal   setcharsize_Pix (int width, int height);

int   PRT__HUGE_PROC pascal   PRT_AllocateBuffer ( void );
int   PRT__HUGE_PROC pascal   PRT_FreeBuffer (void);


   int PRT__HUGE_PROC pascal PRT_installuserdriver ( const char far * name, int huge (*detect)(void) );
   int PRT__HUGE_PROC pascal PRT_registerfarbgidriver ( void far pascal (*driver)(void) );
   int PRT__HUGE_PROC pascal PRT_Unregisterfarbgidriver ( void far pascal(*driver)(void) );
   int PRT__HUGE_PROC pascal PRT_SetViewSize( int x1, int y1, int x2, int y2 );
   int PRT__HUGE_PROC pascal PRT_initgraph( int far * graphdriver, int far *graphmode,
                                       const char far *pathtodriver );
   int PRT__HUGE_PROC pascal PRT_closegraph(void); /* DOES NOT free the buffer   */

   typedef int _PRT__pascal ( PRT__HUGE_PROC * pascal PRT_ErrorFuncP) ( PRT__handleT handle );
   typedef PRT__handleT _PRT__pascal ( PRT__HUGE_PROC * pascal PRT_OpenFuncP)( const char far* outname );
   typedef int _PRT__pascal ( PRT__HUGE_PROC * pascal PRT_CloseFuncP)( PRT__handleT handle );
   typedef int _PRT__pascal ( PRT__HUGE_PROC * pascal PRT_WriteFuncP)( PRT__handleT handle, const void PRT__FAR_PTR * b,
                                                           unsigned len );
PRT_ErrorFuncP PRT__HUGE_PROC pascal PRT_SetErrorFunc ( int far _PRT__pascal WrErrFunc(PRT__handleT handle) );
PRT_OpenFuncP  PRT__HUGE_PROC pascal PRT_SetOpenFunc  ( PRT__handleT far _PRT__pascal f(const char far* outname) );
PRT_CloseFuncP PRT__HUGE_PROC pascal PRT_SetCloseFunc ( int far _PRT__pascal f(PRT__handleT handle) );
PRT_WriteFuncP PRT__HUGE_PROC pascal PRT_SetWriteFunc ( int far _PRT__pascal
                                                  f(PRT__handleT handle,
                                                    const void PRT__FAR_PTR * b,
                                                    unsigned len) );


int pascal CloseCallerBGI ( void );
int pascal RestoreCallerBGI ( int far * graphdriver, int far *graphmode,
                              const char far *pathtodriver );

extern void far pascal BitImage(void);  /* link our bit image BGI driver */

#ifdef __cplusplus
   }
#endif


#ifdef __cplusplus
extern "C" {
#endif
      PRT__handleT _PRT__pascal __PRT_Open(const char far* outname);
      int          _PRT__pascal __PRT_Close( PRT__handleT handle );
      int          _PRT__pascal __PRT_Write( PRT__handleT handle, const void PRT__FAR_PTR * b, unsigned len );
#ifdef __cplusplus
           }
#endif


   /* end of PRTGRAPH.H  */
