/*
** The Window BOSS's Data Clerk
** Copyright (c) 1988 - Philip A. Mongelluzzo
** All rights reserved.
**
** wn_ihmsg - field input help message handler 
**
** Copyright (c) 1988 - Philip A. Mongelluzzo
** All rights reserved.
**
*/

#include "winboss.h"                    /* standard stuff */

/*
************
* wn_ihmsg *
************
*/

/*
** wn_ihmsg(msg)
**
**    (char *)   msg - pointer to message to be displayed.
**
** RETURNS:
**
**    NULL if error, else TRUE
**
** NOTES:
**
**  This routine should be modified or replaced with code to suit
**  your the applications specific needs.  It hooks to wn_input
**  such that whenever the F1 key is pressed wn_input calls wn_ihmsg
**  to display a help message for the field in question.  The hooks
**  in wn_input are of the form:
**
**      if(key_struck == F1) wn_ihmsg;
**
**  This routine displays a single line of help on the last display line 
**  and waits for a key to be struck before returning.
**
**  The help message can be a maximum of 80 characters, and must
**  not contain any formatting directives (\n\t...).
**
*/

/*
************
* wn_ihmsg *
************
*/

wn_ihmsg(msg)                           /* field input help message */
char *msg;                              /* the message to display */
{
WINDOWPTR wn;                           /* a window for me */

  if(!strlen(msg)) return(TRUE);        /* no message - just return */
  if(strlen(msg) > 80) return(NULL);    /* dont be foolish */
  wn=wn_open(1000,(wni_mxrows-1),0,(int)strlen(msg),1,(RVIDEO),NVIDEO);
  if(!wn) return(NULL);                 /* Huh??? */
  wn_puts(wn,0,0,msg);                  /* display message */
  v_getch();                            /* fetch response */
  wn_close(wn);                         /* make message go away */
  return(TRUE);                         /* all done */
}

/* End */
