/*
** The Window BOSS's Data Clerk
** Copyright (c) 1988 - Philip A. Mongelluzzo
** All rights reserved.
**
** wn_guint - get unsigned integer from window with validation 
**
** Copyright (c) 1988 - Philip A. Mongelluzzo
** All rights reserved.
**
*/

#include "winboss.h"                    /* standard stuff */

/*
************
* wn_guint *
************
*/

/*
** wn_guint(fun,frm,fld,wn,row,col,prmpt,atrib,fill,v,fwidth,low,high,ubuff,hlpmsg,errmsg)
**
**    int        fun - fucntion code (SET || XEQ)
**    (WIFORM)   frm - form pointer  (actual || NFRM)
**    int        fld - field # in form (actual || NFLD)
**    (WINDOWPTR)wn  - window pointer
**    int        row - row in window where data input begins
**    int        col - col in window where data input begins
**    (char *) prmpt - field promt (call with NSTR for none)
**    unsigned atrib - field (not prompt) atributes 
**    char      fill - field fill character
**    (unsigned *) v - pointer to int for return value (low-high)
**    int     fwidth - width of mask (maximum # of digits is 6 with sign)
**    unsigned   low - minimum value (lower limit of value)
**    unsigned  high - maximum value (upper limit of value)
**    (char *) ubuff - pointer to char array of 10 bytes for editing 
**    (char *)hlpmsg - pointer to help message (call with NSTR for none)
**    (char *)errmsg - pointer to err message (call with NSTR) for none)
**
** RETURNS:
**
**    V via pointer.
**
**    NULL if error, else the non zero value returned from wn_input.
**
** NOTES:
**
**  FUN -   fun can only be SET for form setup, or XEQ for immediate
**          execution.  When called with SET, valid arguements for both
**          "frm" and "fld" must be specfied.  frm is the field pointer
**          returned from frmopn(), and fld is the field sequence number
**          in the form for this field.  When called with XEQ frm must
**          be NFRM and fld must NFLD.
**
**  UBUFF - Editing buffer.  Must be of sufficent size to hold the
**          data as it is entered.  Typical value is the length
**          of the mask + 2 bytes (strlen(mask)+2).
**
**          On entry, the first byte of ubuff should be 
**          a null, otherwise wn_input assumes there is valid
**          data there and will enter edit mode.  This can be 
**          handy if there is a need for prefilled but editable
**          fields.  In actual pratice, wn_input uses this
**          buffer for both initial character data entry and
**          subsequent editing.
**
**          On return, ubuff contains the actual data entered in
**          character format with fill and mask characters as
**          spaces (e.g. "-24000").
**
**  Calls wn_input to perform data entry.
**
**  Data must satisfy validation checks for function to return.
**
**  Calls wn_iemsg(errmsg) when vaildation fails.
*/

/*
************
* wn_guint *
************
*/

wn_guint(fun,frm,fld,wn,row,col,prmpt,atrib,fill,value,fwidth,low,high,ubuff,hlpmsg,errmsg)
int fun;                                /* SET or XEQ */
WIFORM frm;                             /* form pointer or NFRM */
int fld;                                /* field number or NFLD */
WINDOWPTR wn;                           /* window to use */
int row, col;                           /* position of input field */
char *prmpt;                            /* prompt string */
unsigned atrib;                         /* data entry atribute */
char fill;                              /* fill char */
unsigned int *value, low, high;         /* the int, limits: low & high */
int fwidth;                             /* field width */
char *ubuff;                            /* returns "value" */
char *hlpmsg, *errmsg;                  /* help & error messages */
{
unsigned int v;                         /* temp value */
long lv;                                /* ditto */
char mask[10];                          /* single precision */
unsigned int r;                         /* sscanf return value */
int rv;                                 /* return value */

  if(fun != SET && fun != XEQ)          /* saftey check */
    return(NULL);

  if(fun == SET) {                      /* set up */
    if(frm[fld]->pself != (char *)frm[fld])
      wns_ierr("wn_guint");             /* die if memory is mangled */
    frm[fld]->wn = wn;                  /* set window */
    frm[fld]->row = row;                /* set row */
    frm[fld]->col = col;                /* set col */
    frm[fld]->prmpt = prmpt;            /* set prompt */
    frm[fld]->atrib = atrib;            /* set attribute */
    frm[fld]->fill = fill;              /* set fill character */
    frm[fld]->fcode = GUINT;            /* function code */
    frm[fld]->v1.vuip = value;          /* &value */
    frm[fld]->v2.vui = fwidth;          /* fwidth */
    frm[fld]->v3.vui = low;             /* lower limit */
    frm[fld]->v4.vui = high;            /* upper limit */
    frm[fld]->v5.vcp = ubuff;           /* &ubuff */
    frm[fld]->v6.vcp = hlpmsg;          /* &hlpmsg */
    frm[fld]->v7.vcp = errmsg;          /* &errmsg */
    return(TRUE);
  }

  strcpy(mask,"#######");               /* set mask */
  if(fwidth > 6) {                      /* dont allow foolishness */
    *ubuff = NUL;                       /* indicate error */
    return(NULL);                       /* and return */
  }
  mask[fwidth] = NUL;                   /* set length */
begin:
  if(!(rv=wn_input(wn,row,col,prmpt,mask,fill,atrib,ubuff,hlpmsg))) {
    *ubuff = NUL;                       /* indicate error */
    return(NULL);                       /* indicate error */
  }
  if(wni_frmflg) return(TRUE);          /* wn_frmget in progress */
  if(wns_escape) return(rv);            /* escape pressed ?? */
  r = sscanf(ubuff, "%ld", &lv);        /* convert to long */
  if(r == EOF || r == 0) lv = 0l;       /* no data */
  if(lv < 0 || lv > 65535) {            /* range check data type */
    wn_iemsg(errmsg);                   /* do error message */
    goto begin;                         /* and start over */
  }
  v = (unsigned int)lv;                 /* convert to unsigned int */
  if(v < low || v > high) {             /* bad int */
    wn_iemsg(errmsg);                   /* do error message */
    goto begin;                         /* and start over */
  }
  *value = v;                           /* load user value */
  return(rv);                           /* all is well.. in gross sense */
}

/* End */
