/*
** wn_puts - output string to window
**
** Copyright (c) 1984, 1985, 1986 - Philip A. Mongelluzzo
** All rights reserved.
**
*/

#include "winboss.h"

/*
***********
* wn_puts *
***********
*/

wn_puts(wn, row, col, s)                /* put simple string */
WINDOWPTR wn;
int row,col;
char *s;
{
int matrib;                             /* local attribute */
char *p, *p1, *p2;                      /* local pointer */
int l1,l2;                              /* length of s */
int k;                                  /* scratch */
                                        /* a few OBVIOUS checks */
                                        /* don't allow writing on */
                                        /* or beyond the border, if */
                                        /* one exists */
  matrib = wn->style;                   /* load attribute */
  wns_fixc(&matrib);                    /* fixup */
  k = wn->uly + row + WMR;
  if(k > (wni_mxrows-1)) return(NULL);  /* dont be real stupid */
  if( (k) >= (wn->uly + WMR + wn->ysize) && WMR) return(NULL);

  if(!wn_activate(wn)) return(NULL);    /* bring window to the top */
  wns_err(wn, "wn_puts");               /* avoid disaster */
  l1=strlen(s);                         /* length */
  p = malloc((l1*2)+2);                 /* fetch some memory */
  if(!p) return(NULL);                  /* error */

  while(l1+col > wn->xsize) l1--;       /* dont allow border overflow */
  l2=l1;                                /* carbon copy for savres */
  wn->ccy = row + WMR/2;                /* adjust virtual cursor */
  wn->ccx = col + l1 + WMR/2;
  p1 = p;                               /* set up pointers */
  p2 = s;                               /* for both source & dest */
  while (l1--) {                        /* build char,,atrib */
    *p1++ = *p2++;                      /* pair */
    *p1++ = (char)matrib;               /* for write */
  }
  *p1 = '\0';                           /* terminate string */
  row = wn->uly + row + WMR/2;          /* adjust position */
  col = wn->ulx + col + WMR/2;
  wns_savres(wn->page, row, col, l2, row, p, RESTORE);
  free(p);
  if(wn->synflg)                        /* and position */
    v_locate(wn->page, wn->uly+wn->ccy, wn->ulx+wn->ccx);
  return(TRUE);
}

/*
************
* wn_putsa *
************
*/

wn_putsa(wn, row, col, s, atrib)        /* put simple string with atrib */
WINDOWPTR wn;
int row,col;
char *s;
unsigned atrib;
{
static int satrib;                      /* a place to save current atrib */
int rv;                                 /* return value from wn_puts */
int matrib;

  if(!wn_activate(wn)) return(NULL);    /* bring window to the top */
  matrib = atrib;                       /* my copy */
  wns_err(wn, "wn_putsa");              /* avoid disaster */
  satrib = wn->style;                   /* save current atrib */
  wns_fixc(&matrib);                    /* fixup */
  wn->style = atrib;                    /* force new atrib */
  rv = wn_puts(wn, row, col, s);        /* do it with wn_puts */
  wn->style = satrib;                   /* restore atrib */
  return(rv);
}


/*
***********
* wn_putc *
***********
*/

wn_putc(wn, row, col, c)                /* put simple character */
WINDOWPTR wn;                           /* the window */
int row,col;                            /* location */
char c;                                 /* the character */
{
char s[3];                              /* character string */

  if(!wn_activate(wn)) return(NULL);    /* bring window to the top */   
  wns_err(wn, "wn_putc");               /* avoid disaster */
  s[0] = c;                             /* load character */
  s[1] = '\0';                          /* terminate string */
  return(wn_puts(wn, row, col, s));     /* print the string */
}

/*
************
* wn_putca *
************
*/

wn_putca(wn, row, col, c, a)            /* put simple character & atrib */
WINDOWPTR wn;                           /* the window */
int row,col;                            /* location */
char c;                                 /* the character */
unsigned a;                             /* the attribute */
{
char s[3];                              /* character string */

  if(!wn_activate(wn)) return(NULL);    /* bring window to the top */   
  wns_err(wn, "wn_putca");              /* avoid disaster */
  s[0] = c;                             /* load character */
  s[1] = '\0';                          /* terminate string */
  return(wn_putsa(wn, row, col, s, a)); /* print the string & atrib */
}

/*
************
* wn_getca *
************
*/

unsigned int wn_getca(wn, row, col)
WINDOWPTR wn;
int row, col;

{
  if(!wn_activate(wn)) return(NULL);    /* make sure window is on top */
  wns_err(wn,"wn_getca");               /* avoid disaster */

  row = row + wn->uly+WMR/2;            /* set physical address */
  col = col + wn->ulx+WMR/2;
  return(_getca(wn->page,row,col));     /* return char & attribute */
}

/* End */
